package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  Integer,
  NonEmptyString,
  ControlSetId
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssessmentControlSet(
    id: Optional[ControlSetId] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[zio.aws.auditmanager.model.ControlSetStatus] =
      Optional.Absent,
    roles: Optional[Iterable[zio.aws.auditmanager.model.Role]] =
      Optional.Absent,
    controls: Optional[Iterable[zio.aws.auditmanager.model.AssessmentControl]] =
      Optional.Absent,
    delegations: Optional[Iterable[zio.aws.auditmanager.model.Delegation]] =
      Optional.Absent,
    systemEvidenceCount: Optional[Integer] = Optional.Absent,
    manualEvidenceCount: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssessmentControlSet = {
    import AssessmentControlSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssessmentControlSet
      .builder()
      .optionallyWith(
        id.map(value => ControlSetId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        roles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.roles)
      .optionallyWith(
        controls.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controls)
      .optionallyWith(
        delegations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.delegations)
      .optionallyWith(
        systemEvidenceCount.map(value => value: java.lang.Integer)
      )(_.systemEvidenceCount)
      .optionallyWith(
        manualEvidenceCount.map(value => value: java.lang.Integer)
      )(_.manualEvidenceCount)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.AssessmentControlSet.ReadOnly =
    zio.aws.auditmanager.model.AssessmentControlSet.wrap(buildAwsValue())
}
object AssessmentControlSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssessmentControlSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AssessmentControlSet =
      zio.aws.auditmanager.model.AssessmentControlSet(
        id.map(value => value),
        description.map(value => value),
        status.map(value => value),
        roles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        controls.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        delegations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        systemEvidenceCount.map(value => value),
        manualEvidenceCount.map(value => value)
      )
    def id: Optional[ControlSetId]
    def description: Optional[NonEmptyString]
    def status: Optional[zio.aws.auditmanager.model.ControlSetStatus]
    def roles: Optional[List[zio.aws.auditmanager.model.Role.ReadOnly]]
    def controls
        : Optional[List[zio.aws.auditmanager.model.AssessmentControl.ReadOnly]]
    def delegations
        : Optional[List[zio.aws.auditmanager.model.Delegation.ReadOnly]]
    def systemEvidenceCount: Optional[Integer]
    def manualEvidenceCount: Optional[Integer]
    def getId: ZIO[Any, AwsError, ControlSetId] =
      AwsError.unwrapOptionField("id", id)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.ControlSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRoles
        : ZIO[Any, AwsError, List[zio.aws.auditmanager.model.Role.ReadOnly]] =
      AwsError.unwrapOptionField("roles", roles)
    def getControls: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.AssessmentControl.ReadOnly
    ]] = AwsError.unwrapOptionField("controls", controls)
    def getDelegations: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.Delegation.ReadOnly
    ]] = AwsError.unwrapOptionField("delegations", delegations)
    def getSystemEvidenceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("systemEvidenceCount", systemEvidenceCount)
    def getManualEvidenceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("manualEvidenceCount", manualEvidenceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentControlSet
  ) extends zio.aws.auditmanager.model.AssessmentControlSet.ReadOnly {
    override val id: Optional[ControlSetId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.ControlSetId(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
    override val status: Optional[zio.aws.auditmanager.model.ControlSetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.auditmanager.model.ControlSetStatus.wrap(value))
    override val roles
        : Optional[List[zio.aws.auditmanager.model.Role.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.Role.wrap(item)
          }.toList
        )
    override val controls: Optional[
      List[zio.aws.auditmanager.model.AssessmentControl.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.controls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.AssessmentControl.wrap(item)
        }.toList
      )
    override val delegations
        : Optional[List[zio.aws.auditmanager.model.Delegation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.delegations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.Delegation.wrap(item)
          }.toList
        )
    override val systemEvidenceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.systemEvidenceCount())
      .map(value => value: Integer)
    override val manualEvidenceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.manualEvidenceCount())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentControlSet
  ): zio.aws.auditmanager.model.AssessmentControlSet.ReadOnly = new Wrapper(
    impl
  )
}
