package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters.*
sealed trait ObjectTypeEnum {
  def unwrap: software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum
}
object ObjectTypeEnum {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum
  ): zio.aws.auditmanager.model.ObjectTypeEnum = value match {
    case software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum.ASSESSMENT =>
      val r = ASSESSMENT
      r
    case software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum.CONTROL_SET =>
      val r = CONTROL_SET
      r
    case software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum.CONTROL =>
      val r = CONTROL
      r
    case software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum.DELEGATION =>
      val r = DELEGATION
      r
    case software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum.ASSESSMENT_REPORT =>
      val r = ASSESSMENT_REPORT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.ObjectTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum =
      software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum.UNKNOWN_TO_SDK_VERSION
  }
  case object ASSESSMENT extends zio.aws.auditmanager.model.ObjectTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum =
      software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum.ASSESSMENT
  }
  case object CONTROL_SET extends zio.aws.auditmanager.model.ObjectTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum =
      software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum.CONTROL_SET
  }
  case object CONTROL extends zio.aws.auditmanager.model.ObjectTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum =
      software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum.CONTROL
  }
  case object DELEGATION extends zio.aws.auditmanager.model.ObjectTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum =
      software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum.DELEGATION
  }
  case object ASSESSMENT_REPORT
      extends zio.aws.auditmanager.model.ObjectTypeEnum {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum =
      software.amazon.awssdk.services.auditmanager.model.ObjectTypeEnum.ASSESSMENT_REPORT
  }
}
