package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters.*
sealed trait ControlResponse {
  def unwrap: software.amazon.awssdk.services.auditmanager.model.ControlResponse
}
object ControlResponse {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.ControlResponse
  ): zio.aws.auditmanager.model.ControlResponse = value match {
    case software.amazon.awssdk.services.auditmanager.model.ControlResponse.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.ControlResponse.MANUAL =>
      val r = MANUAL
      r
    case software.amazon.awssdk.services.auditmanager.model.ControlResponse.AUTOMATE =>
      val r = AUTOMATE
      r
    case software.amazon.awssdk.services.auditmanager.model.ControlResponse.DEFER =>
      val r = DEFER
      r
    case software.amazon.awssdk.services.auditmanager.model.ControlResponse.IGNORE =>
      val r = IGNORE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.ControlResponse {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ControlResponse =
      software.amazon.awssdk.services.auditmanager.model.ControlResponse.UNKNOWN_TO_SDK_VERSION
  }
  case object MANUAL extends zio.aws.auditmanager.model.ControlResponse {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ControlResponse =
      software.amazon.awssdk.services.auditmanager.model.ControlResponse.MANUAL
  }
  case object AUTOMATE extends zio.aws.auditmanager.model.ControlResponse {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ControlResponse =
      software.amazon.awssdk.services.auditmanager.model.ControlResponse.AUTOMATE
  }
  case object DEFER extends zio.aws.auditmanager.model.ControlResponse {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ControlResponse =
      software.amazon.awssdk.services.auditmanager.model.ControlResponse.DEFER
  }
  case object IGNORE extends zio.aws.auditmanager.model.ControlResponse {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ControlResponse =
      software.amazon.awssdk.services.auditmanager.model.ControlResponse.IGNORE
  }
}
