package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListControlsResponse(
    controlMetadataList: Optional[
      Iterable[zio.aws.auditmanager.model.ControlMetadata]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListControlsResponse = {
    import ListControlsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListControlsResponse
      .builder()
      .optionallyWith(
        controlMetadataList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controlMetadataList)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ListControlsResponse.ReadOnly =
    zio.aws.auditmanager.model.ListControlsResponse.wrap(buildAwsValue())
}
object ListControlsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListControlsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ListControlsResponse =
      zio.aws.auditmanager.model.ListControlsResponse(
        controlMetadataList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def controlMetadataList
        : Optional[List[zio.aws.auditmanager.model.ControlMetadata.ReadOnly]]
    def nextToken: Optional[Token]
    def getControlMetadataList: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.ControlMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("controlMetadataList", controlMetadataList)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListControlsResponse
  ) extends zio.aws.auditmanager.model.ListControlsResponse.ReadOnly {
    override val controlMetadataList
        : Optional[List[zio.aws.auditmanager.model.ControlMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlMetadataList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.ControlMetadata.wrap(item)
          }.toList
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListControlsResponse
  ): zio.aws.auditmanager.model.ListControlsResponse.ReadOnly = new Wrapper(
    impl
  )
}
