package zio.aws.auditmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{
  AuditManagerArn,
  FrameworkName,
  Filename,
  Timestamp,
  TagValue,
  FrameworkDescription,
  ComplianceType,
  LastUpdatedBy,
  UUID,
  ControlSources,
  CreatedBy,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Framework(
    arn: Optional[AuditManagerArn] = Optional.Absent,
    id: Optional[UUID] = Optional.Absent,
    name: Optional[FrameworkName] = Optional.Absent,
    `type`: Optional[zio.aws.auditmanager.model.FrameworkType] =
      Optional.Absent,
    complianceType: Optional[ComplianceType] = Optional.Absent,
    description: Optional[FrameworkDescription] = Optional.Absent,
    logo: Optional[Filename] = Optional.Absent,
    controlSources: Optional[ControlSources] = Optional.Absent,
    controlSets: Optional[Iterable[zio.aws.auditmanager.model.ControlSet]] =
      Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    lastUpdatedBy: Optional[LastUpdatedBy] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Framework = {
    import Framework.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Framework
      .builder()
      .optionallyWith(
        arn.map(value => AuditManagerArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => FrameworkName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        complianceType.map(value =>
          ComplianceType.unwrap(value): java.lang.String
        )
      )(_.complianceType)
      .optionallyWith(
        description.map(value =>
          FrameworkDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        logo.map(value => Filename.unwrap(value): java.lang.String)
      )(_.logo)
      .optionallyWith(
        controlSources.map(value =>
          ControlSources.unwrap(value): java.lang.String
        )
      )(_.controlSources)
      .optionallyWith(
        controlSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controlSets)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        lastUpdatedBy.map(value =>
          LastUpdatedBy.unwrap(value): java.lang.String
        )
      )(_.lastUpdatedBy)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Framework.ReadOnly =
    zio.aws.auditmanager.model.Framework.wrap(buildAwsValue())
}
object Framework {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Framework
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Framework =
      zio.aws.auditmanager.model.Framework(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        complianceType.map(value => value),
        description.map(value => value),
        logo.map(value => value),
        controlSources.map(value => value),
        controlSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        createdBy.map(value => value),
        lastUpdatedBy.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[AuditManagerArn]
    def id: Optional[UUID]
    def name: Optional[FrameworkName]
    def `type`: Optional[zio.aws.auditmanager.model.FrameworkType]
    def complianceType: Optional[ComplianceType]
    def description: Optional[FrameworkDescription]
    def logo: Optional[Filename]
    def controlSources: Optional[ControlSources]
    def controlSets
        : Optional[List[zio.aws.auditmanager.model.ControlSet.ReadOnly]]
    def createdAt: Optional[Timestamp]
    def lastUpdatedAt: Optional[Timestamp]
    def createdBy: Optional[CreatedBy]
    def lastUpdatedBy: Optional[LastUpdatedBy]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, AuditManagerArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, FrameworkName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.auditmanager.model.FrameworkType] =
      AwsError.unwrapOptionField("type", `type`)
    def getComplianceType: ZIO[Any, AwsError, ComplianceType] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getDescription: ZIO[Any, AwsError, FrameworkDescription] =
      AwsError.unwrapOptionField("description", description)
    def getLogo: ZIO[Any, AwsError, Filename] =
      AwsError.unwrapOptionField("logo", logo)
    def getControlSources: ZIO[Any, AwsError, ControlSources] =
      AwsError.unwrapOptionField("controlSources", controlSources)
    def getControlSets: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.ControlSet.ReadOnly
    ]] = AwsError.unwrapOptionField("controlSets", controlSets)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastUpdatedBy: ZIO[Any, AwsError, LastUpdatedBy] =
      AwsError.unwrapOptionField("lastUpdatedBy", lastUpdatedBy)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Framework
  ) extends zio.aws.auditmanager.model.Framework.ReadOnly {
    override val arn: Optional[AuditManagerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.auditmanager.model.primitives.AuditManagerArn(value)
      )
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val name: Optional[FrameworkName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.FrameworkName(value))
    override val `type`: Optional[zio.aws.auditmanager.model.FrameworkType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.auditmanager.model.FrameworkType.wrap(value))
    override val complianceType: Optional[ComplianceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value =>
          zio.aws.auditmanager.model.primitives.ComplianceType(value)
        )
    override val description: Optional[FrameworkDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.auditmanager.model.primitives.FrameworkDescription(value)
        )
    override val logo: Optional[Filename] = zio.aws.core.internal
      .optionalFromNullable(impl.logo())
      .map(value => zio.aws.auditmanager.model.primitives.Filename(value))
    override val controlSources: Optional[ControlSources] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlSources())
        .map(value =>
          zio.aws.auditmanager.model.primitives.ControlSources(value)
        )
    override val controlSets
        : Optional[List[zio.aws.auditmanager.model.ControlSet.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.ControlSet.wrap(item)
          }.toList
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.auditmanager.model.primitives.CreatedBy(value))
    override val lastUpdatedBy: Optional[LastUpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedBy())
      .map(value => zio.aws.auditmanager.model.primitives.LastUpdatedBy(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.auditmanager.model.primitives.TagKey(
              key
            ) -> zio.aws.auditmanager.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Framework
  ): zio.aws.auditmanager.model.Framework.ReadOnly = new Wrapper(impl)
}
