package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters.*
sealed trait AssessmentStatus {
  def unwrap
      : software.amazon.awssdk.services.auditmanager.model.AssessmentStatus
}
object AssessmentStatus {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.AssessmentStatus
  ): zio.aws.auditmanager.model.AssessmentStatus = value match {
    case software.amazon.awssdk.services.auditmanager.model.AssessmentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.AssessmentStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.auditmanager.model.AssessmentStatus.INACTIVE =>
      val r = INACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.AssessmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.AssessmentStatus =
      software.amazon.awssdk.services.auditmanager.model.AssessmentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.auditmanager.model.AssessmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.AssessmentStatus =
      software.amazon.awssdk.services.auditmanager.model.AssessmentStatus.ACTIVE
  }
  case object INACTIVE extends zio.aws.auditmanager.model.AssessmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.AssessmentStatus =
      software.amazon.awssdk.services.auditmanager.model.AssessmentStatus.INACTIVE
  }
}
