package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters.*
sealed trait SourceSetUpOption {
  def unwrap
      : software.amazon.awssdk.services.auditmanager.model.SourceSetUpOption
}
object SourceSetUpOption {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.SourceSetUpOption
  ): zio.aws.auditmanager.model.SourceSetUpOption = value match {
    case software.amazon.awssdk.services.auditmanager.model.SourceSetUpOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.SourceSetUpOption.SYSTEM_CONTROLS_MAPPING =>
      val r = System_Controls_Mapping
      r
    case software.amazon.awssdk.services.auditmanager.model.SourceSetUpOption.PROCEDURAL_CONTROLS_MAPPING =>
      val r = Procedural_Controls_Mapping
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.SourceSetUpOption {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SourceSetUpOption =
      software.amazon.awssdk.services.auditmanager.model.SourceSetUpOption.UNKNOWN_TO_SDK_VERSION
  }
  case object System_Controls_Mapping
      extends zio.aws.auditmanager.model.SourceSetUpOption {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SourceSetUpOption =
      software.amazon.awssdk.services.auditmanager.model.SourceSetUpOption.SYSTEM_CONTROLS_MAPPING
  }
  case object Procedural_Controls_Mapping
      extends zio.aws.auditmanager.model.SourceSetUpOption {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.SourceSetUpOption =
      software.amazon.awssdk.services.auditmanager.model.SourceSetUpOption.PROCEDURAL_CONTROLS_MAPPING
  }
}
