package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateAssessmentControlSetStatusResponse(
    controlSet: Optional[zio.aws.auditmanager.model.AssessmentControlSet] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusResponse = {
    import UpdateAssessmentControlSetStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusResponse
      .builder()
      .optionallyWith(controlSet.map(value => value.buildAwsValue()))(
        _.controlSet
      )
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusResponse.ReadOnly =
    zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusResponse
      .wrap(buildAwsValue())
}
object UpdateAssessmentControlSetStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusResponse =
      zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusResponse(
        controlSet.map(value => value.asEditable)
      )
    def controlSet
        : Optional[zio.aws.auditmanager.model.AssessmentControlSet.ReadOnly]
    def getControlSet: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.AssessmentControlSet.ReadOnly
    ] = AwsError.unwrapOptionField("controlSet", controlSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusResponse
  ) extends zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusResponse.ReadOnly {
    override val controlSet
        : Optional[zio.aws.auditmanager.model.AssessmentControlSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlSet())
        .map(value =>
          zio.aws.auditmanager.model.AssessmentControlSet.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusResponse
  ): zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusResponse.ReadOnly =
    new Wrapper(impl)
}
