package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.{DelegationComment, UUID}
import scala.jdk.CollectionConverters.*
final case class UpdateAssessmentControlSetStatusRequest(
    assessmentId: UUID,
    controlSetId: String,
    status: zio.aws.auditmanager.model.ControlSetStatus,
    comment: DelegationComment
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusRequest = {
    import UpdateAssessmentControlSetStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .controlSetId(controlSetId: java.lang.String)
      .status(status.unwrap)
      .comment(DelegationComment.unwrap(comment): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusRequest.ReadOnly =
    zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusRequest
      .wrap(buildAwsValue())
}
object UpdateAssessmentControlSetStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusRequest =
      zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusRequest(
        assessmentId,
        controlSetId,
        status,
        comment
      )
    def assessmentId: UUID
    def controlSetId: String
    def status: zio.aws.auditmanager.model.ControlSetStatus
    def comment: DelegationComment
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
    def getControlSetId: ZIO[Any, Nothing, String] = ZIO.succeed(controlSetId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.auditmanager.model.ControlSetStatus] =
      ZIO.succeed(status)
    def getComment: ZIO[Any, Nothing, DelegationComment] = ZIO.succeed(comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusRequest
  ) extends zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
    override val controlSetId: String = impl.controlSetId(): String
    override val status: zio.aws.auditmanager.model.ControlSetStatus =
      zio.aws.auditmanager.model.ControlSetStatus.wrap(impl.status())
    override val comment: DelegationComment =
      zio.aws.auditmanager.model.primitives.DelegationComment(impl.comment())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusRequest
  ): zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusRequest.ReadOnly =
    new Wrapper(impl)
}
