package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDelegationsResponse(
    delegations: Optional[
      Iterable[zio.aws.auditmanager.model.DelegationMetadata]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetDelegationsResponse = {
    import GetDelegationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetDelegationsResponse
      .builder()
      .optionallyWith(
        delegations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.delegations)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.GetDelegationsResponse.ReadOnly =
    zio.aws.auditmanager.model.GetDelegationsResponse.wrap(buildAwsValue())
}
object GetDelegationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetDelegationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetDelegationsResponse =
      zio.aws.auditmanager.model.GetDelegationsResponse(
        delegations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def delegations
        : Optional[List[zio.aws.auditmanager.model.DelegationMetadata.ReadOnly]]
    def nextToken: Optional[Token]
    def getDelegations: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.DelegationMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("delegations", delegations)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetDelegationsResponse
  ) extends zio.aws.auditmanager.model.GetDelegationsResponse.ReadOnly {
    override val delegations: Optional[
      List[zio.aws.auditmanager.model.DelegationMetadata.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.delegations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.DelegationMetadata.wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetDelegationsResponse
  ): zio.aws.auditmanager.model.GetDelegationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
