package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters.*
final case class DeleteAssessmentReportRequest(
    assessmentId: UUID,
    assessmentReportId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentReportRequest = {
    import DeleteAssessmentReportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentReportRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .assessmentReportId(UUID.unwrap(assessmentReportId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.DeleteAssessmentReportRequest.ReadOnly =
    zio.aws.auditmanager.model.DeleteAssessmentReportRequest
      .wrap(buildAwsValue())
}
object DeleteAssessmentReportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentReportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.DeleteAssessmentReportRequest =
      zio.aws.auditmanager.model
        .DeleteAssessmentReportRequest(assessmentId, assessmentReportId)
    def assessmentId: UUID
    def assessmentReportId: UUID
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
    def getAssessmentReportId: ZIO[Any, Nothing, UUID] =
      ZIO.succeed(assessmentReportId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentReportRequest
  ) extends zio.aws.auditmanager.model.DeleteAssessmentReportRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
    override val assessmentReportId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentReportId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentReportRequest
  ): zio.aws.auditmanager.model.DeleteAssessmentReportRequest.ReadOnly =
    new Wrapper(impl)
}
