package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters.*
sealed trait ControlSetStatus {
  def unwrap
      : software.amazon.awssdk.services.auditmanager.model.ControlSetStatus
}
object ControlSetStatus {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.ControlSetStatus
  ): zio.aws.auditmanager.model.ControlSetStatus = value match {
    case software.amazon.awssdk.services.auditmanager.model.ControlSetStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.ControlSetStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.auditmanager.model.ControlSetStatus.UNDER_REVIEW =>
      val r = UNDER_REVIEW
      r
    case software.amazon.awssdk.services.auditmanager.model.ControlSetStatus.REVIEWED =>
      val r = REVIEWED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.ControlSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ControlSetStatus =
      software.amazon.awssdk.services.auditmanager.model.ControlSetStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.auditmanager.model.ControlSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ControlSetStatus =
      software.amazon.awssdk.services.auditmanager.model.ControlSetStatus.ACTIVE
  }
  case object UNDER_REVIEW extends zio.aws.auditmanager.model.ControlSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ControlSetStatus =
      software.amazon.awssdk.services.auditmanager.model.ControlSetStatus.UNDER_REVIEW
  }
  case object REVIEWED extends zio.aws.auditmanager.model.ControlSetStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ControlSetStatus =
      software.amazon.awssdk.services.auditmanager.model.ControlSetStatus.REVIEWED
  }
}
