package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAssessmentControlInsightsByControlDomainResponse(
    controlInsightsByAssessment: Optional[Iterable[
      zio.aws.auditmanager.model.ControlInsightsMetadataByAssessmentItem
    ]] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse = {
    import ListAssessmentControlInsightsByControlDomainResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse
      .builder()
      .optionallyWith(
        controlInsightsByAssessment.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controlInsightsByAssessment)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse.ReadOnly =
    zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse
      .wrap(buildAwsValue())
}
object ListAssessmentControlInsightsByControlDomainResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse =
      zio.aws.auditmanager.model
        .ListAssessmentControlInsightsByControlDomainResponse(
          controlInsightsByAssessment.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def controlInsightsByAssessment: Optional[List[
      zio.aws.auditmanager.model.ControlInsightsMetadataByAssessmentItem.ReadOnly
    ]]
    def nextToken: Optional[Token]
    def getControlInsightsByAssessment: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.ControlInsightsMetadataByAssessmentItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "controlInsightsByAssessment",
      controlInsightsByAssessment
    )
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse
  ) extends zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse.ReadOnly {
    override val controlInsightsByAssessment: Optional[List[
      zio.aws.auditmanager.model.ControlInsightsMetadataByAssessmentItem.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.controlInsightsByAssessment())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.ControlInsightsMetadataByAssessmentItem
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse
  ): zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse.ReadOnly =
    new Wrapper(impl)
}
