package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters.*
final case class GetAssessmentFrameworkRequest(frameworkId: UUID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkRequest = {
    import GetAssessmentFrameworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkRequest
      .builder()
      .frameworkId(UUID.unwrap(frameworkId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetAssessmentFrameworkRequest.ReadOnly =
    zio.aws.auditmanager.model.GetAssessmentFrameworkRequest
      .wrap(buildAwsValue())
}
object GetAssessmentFrameworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetAssessmentFrameworkRequest =
      zio.aws.auditmanager.model.GetAssessmentFrameworkRequest(frameworkId)
    def frameworkId: UUID
    def getFrameworkId: ZIO[Any, Nothing, UUID] = ZIO.succeed(frameworkId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkRequest
  ) extends zio.aws.auditmanager.model.GetAssessmentFrameworkRequest.ReadOnly {
    override val frameworkId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.frameworkId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkRequest
  ): zio.aws.auditmanager.model.GetAssessmentFrameworkRequest.ReadOnly =
    new Wrapper(impl)
}
