package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeregistrationPolicy(
    deleteResources: Optional[zio.aws.auditmanager.model.DeleteResources] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.DeregistrationPolicy = {
    import DeregistrationPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.DeregistrationPolicy
      .builder()
      .optionallyWith(deleteResources.map(value => value.unwrap))(
        _.deleteResources
      )
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.DeregistrationPolicy.ReadOnly =
    zio.aws.auditmanager.model.DeregistrationPolicy.wrap(buildAwsValue())
}
object DeregistrationPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.DeregistrationPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.DeregistrationPolicy =
      zio.aws.auditmanager.model
        .DeregistrationPolicy(deleteResources.map(value => value))
    def deleteResources: Optional[zio.aws.auditmanager.model.DeleteResources]
    def getDeleteResources
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.DeleteResources] =
      AwsError.unwrapOptionField("deleteResources", deleteResources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.DeregistrationPolicy
  ) extends zio.aws.auditmanager.model.DeregistrationPolicy.ReadOnly {
    override val deleteResources
        : Optional[zio.aws.auditmanager.model.DeleteResources] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteResources())
        .map(value => zio.aws.auditmanager.model.DeleteResources.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.DeregistrationPolicy
  ): zio.aws.auditmanager.model.DeregistrationPolicy.ReadOnly = new Wrapper(
    impl
  )
}
