package zio.aws.auditmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{
  AssessmentName,
  AccountId,
  Timestamp,
  UUID,
  AssessmentReportName,
  AssessmentReportDescription,
  Username
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AssessmentReport(
    id: Optional[UUID] = Optional.Absent,
    name: Optional[AssessmentReportName] = Optional.Absent,
    description: Optional[AssessmentReportDescription] = Optional.Absent,
    awsAccountId: Optional[AccountId] = Optional.Absent,
    assessmentId: Optional[UUID] = Optional.Absent,
    assessmentName: Optional[AssessmentName] = Optional.Absent,
    author: Optional[Username] = Optional.Absent,
    status: Optional[zio.aws.auditmanager.model.AssessmentReportStatus] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssessmentReport = {
    import AssessmentReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssessmentReport
      .builder()
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => AssessmentReportName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          AssessmentReportDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        awsAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .optionallyWith(
        assessmentId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.assessmentId)
      .optionallyWith(
        assessmentName.map(value =>
          AssessmentName.unwrap(value): java.lang.String
        )
      )(_.assessmentName)
      .optionallyWith(
        author.map(value => Username.unwrap(value): java.lang.String)
      )(_.author)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.AssessmentReport.ReadOnly =
    zio.aws.auditmanager.model.AssessmentReport.wrap(buildAwsValue())
}
object AssessmentReport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssessmentReport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AssessmentReport =
      zio.aws.auditmanager.model.AssessmentReport(
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        awsAccountId.map(value => value),
        assessmentId.map(value => value),
        assessmentName.map(value => value),
        author.map(value => value),
        status.map(value => value),
        creationTime.map(value => value)
      )
    def id: Optional[UUID]
    def name: Optional[AssessmentReportName]
    def description: Optional[AssessmentReportDescription]
    def awsAccountId: Optional[AccountId]
    def assessmentId: Optional[UUID]
    def assessmentName: Optional[AssessmentName]
    def author: Optional[Username]
    def status: Optional[zio.aws.auditmanager.model.AssessmentReportStatus]
    def creationTime: Optional[Timestamp]
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, AssessmentReportName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, AssessmentReportDescription] =
      AwsError.unwrapOptionField("description", description)
    def getAwsAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getAssessmentId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("assessmentId", assessmentId)
    def getAssessmentName: ZIO[Any, AwsError, AssessmentName] =
      AwsError.unwrapOptionField("assessmentName", assessmentName)
    def getAuthor: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("author", author)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.AssessmentReportStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentReport
  ) extends zio.aws.auditmanager.model.AssessmentReport.ReadOnly {
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val name: Optional[AssessmentReportName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.auditmanager.model.primitives.AssessmentReportName(value)
      )
    override val description: Optional[AssessmentReportDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.auditmanager.model.primitives
            .AssessmentReportDescription(value)
        )
    override val awsAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.auditmanager.model.primitives.AccountId(value))
    override val assessmentId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.assessmentId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val assessmentName: Optional[AssessmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assessmentName())
        .map(value =>
          zio.aws.auditmanager.model.primitives.AssessmentName(value)
        )
    override val author: Optional[Username] = zio.aws.core.internal
      .optionalFromNullable(impl.author())
      .map(value => zio.aws.auditmanager.model.primitives.Username(value))
    override val status
        : Optional[zio.aws.auditmanager.model.AssessmentReportStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.auditmanager.model.AssessmentReportStatus.wrap(value)
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentReport
  ): zio.aws.auditmanager.model.AssessmentReport.ReadOnly = new Wrapper(impl)
}
