package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters.*
sealed trait ShareRequestStatus {
  def unwrap
      : software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus
}
object ShareRequestStatus {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus
  ): zio.aws.auditmanager.model.ShareRequestStatus = value match {
    case software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.REPLICATING =>
      val r = REPLICATING
      r
    case software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.SHARED =>
      val r = SHARED
      r
    case software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.EXPIRING =>
      val r = EXPIRING
      r
    case software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.EXPIRED =>
      val r = EXPIRED
      r
    case software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.DECLINED =>
      val r = DECLINED
      r
    case software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.REVOKED =>
      val r = REVOKED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.ShareRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus =
      software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.auditmanager.model.ShareRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus =
      software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.ACTIVE
  }
  case object REPLICATING
      extends zio.aws.auditmanager.model.ShareRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus =
      software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.REPLICATING
  }
  case object SHARED extends zio.aws.auditmanager.model.ShareRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus =
      software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.SHARED
  }
  case object EXPIRING extends zio.aws.auditmanager.model.ShareRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus =
      software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.EXPIRING
  }
  case object FAILED extends zio.aws.auditmanager.model.ShareRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus =
      software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.FAILED
  }
  case object EXPIRED extends zio.aws.auditmanager.model.ShareRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus =
      software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.EXPIRED
  }
  case object DECLINED extends zio.aws.auditmanager.model.ShareRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus =
      software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.DECLINED
  }
  case object REVOKED extends zio.aws.auditmanager.model.ShareRequestStatus {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus =
      software.amazon.awssdk.services.auditmanager.model.ShareRequestStatus.REVOKED
  }
}
