package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAssessmentResponse(
    assessment: Optional[zio.aws.auditmanager.model.Assessment] =
      Optional.Absent,
    userRole: Optional[zio.aws.auditmanager.model.Role] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetAssessmentResponse = {
    import GetAssessmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetAssessmentResponse
      .builder()
      .optionallyWith(assessment.map(value => value.buildAwsValue()))(
        _.assessment
      )
      .optionallyWith(userRole.map(value => value.buildAwsValue()))(_.userRole)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.GetAssessmentResponse.ReadOnly =
    zio.aws.auditmanager.model.GetAssessmentResponse.wrap(buildAwsValue())
}
object GetAssessmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetAssessmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetAssessmentResponse =
      zio.aws.auditmanager.model.GetAssessmentResponse(
        assessment.map(value => value.asEditable),
        userRole.map(value => value.asEditable)
      )
    def assessment: Optional[zio.aws.auditmanager.model.Assessment.ReadOnly]
    def userRole: Optional[zio.aws.auditmanager.model.Role.ReadOnly]
    def getAssessment
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.Assessment.ReadOnly] =
      AwsError.unwrapOptionField("assessment", assessment)
    def getUserRole
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.Role.ReadOnly] =
      AwsError.unwrapOptionField("userRole", userRole)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetAssessmentResponse
  ) extends zio.aws.auditmanager.model.GetAssessmentResponse.ReadOnly {
    override val assessment
        : Optional[zio.aws.auditmanager.model.Assessment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assessment())
        .map(value => zio.aws.auditmanager.model.Assessment.wrap(value))
    override val userRole: Optional[zio.aws.auditmanager.model.Role.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userRole())
        .map(value => zio.aws.auditmanager.model.Role.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetAssessmentResponse
  ): zio.aws.auditmanager.model.GetAssessmentResponse.ReadOnly = new Wrapper(
    impl
  )
}
