package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters.*
final case class DeleteAssessmentFrameworkRequest(frameworkId: UUID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkRequest = {
    import DeleteAssessmentFrameworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkRequest
      .builder()
      .frameworkId(UUID.unwrap(frameworkId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.DeleteAssessmentFrameworkRequest.ReadOnly =
    zio.aws.auditmanager.model.DeleteAssessmentFrameworkRequest
      .wrap(buildAwsValue())
}
object DeleteAssessmentFrameworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.DeleteAssessmentFrameworkRequest =
      zio.aws.auditmanager.model.DeleteAssessmentFrameworkRequest(frameworkId)
    def frameworkId: UUID
    def getFrameworkId: ZIO[Any, Nothing, UUID] = ZIO.succeed(frameworkId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkRequest
  ) extends zio.aws.auditmanager.model.DeleteAssessmentFrameworkRequest.ReadOnly {
    override val frameworkId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.frameworkId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkRequest
  ): zio.aws.auditmanager.model.DeleteAssessmentFrameworkRequest.ReadOnly =
    new Wrapper(impl)
}
