package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters.*
final case class AssociateAssessmentReportEvidenceFolderRequest(
    assessmentId: UUID,
    evidenceFolderId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest = {
    import AssociateAssessmentReportEvidenceFolderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .evidenceFolderId(UUID.unwrap(evidenceFolderId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest.ReadOnly =
    zio.aws.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest
      .wrap(buildAwsValue())
}
object AssociateAssessmentReportEvidenceFolderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest =
      zio.aws.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest(
        assessmentId,
        evidenceFolderId
      )
    def assessmentId: UUID
    def evidenceFolderId: UUID
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
    def getEvidenceFolderId: ZIO[Any, Nothing, UUID] =
      ZIO.succeed(evidenceFolderId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest
  ) extends zio.aws.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
    override val evidenceFolderId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.evidenceFolderId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest
  ): zio.aws.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest.ReadOnly =
    new Wrapper(impl)
}
