package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters.*
sealed trait ShareRequestAction {
  def unwrap
      : software.amazon.awssdk.services.auditmanager.model.ShareRequestAction
}
object ShareRequestAction {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.ShareRequestAction
  ): zio.aws.auditmanager.model.ShareRequestAction = value match {
    case software.amazon.awssdk.services.auditmanager.model.ShareRequestAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.ShareRequestAction.ACCEPT =>
      val r = ACCEPT
      r
    case software.amazon.awssdk.services.auditmanager.model.ShareRequestAction.DECLINE =>
      val r = DECLINE
      r
    case software.amazon.awssdk.services.auditmanager.model.ShareRequestAction.REVOKE =>
      val r = REVOKE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.ShareRequestAction {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ShareRequestAction =
      software.amazon.awssdk.services.auditmanager.model.ShareRequestAction.UNKNOWN_TO_SDK_VERSION
  }
  case object ACCEPT extends zio.aws.auditmanager.model.ShareRequestAction {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ShareRequestAction =
      software.amazon.awssdk.services.auditmanager.model.ShareRequestAction.ACCEPT
  }
  case object DECLINE extends zio.aws.auditmanager.model.ShareRequestAction {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ShareRequestAction =
      software.amazon.awssdk.services.auditmanager.model.ShareRequestAction.DECLINE
  }
  case object REVOKE extends zio.aws.auditmanager.model.ShareRequestAction {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ShareRequestAction =
      software.amazon.awssdk.services.auditmanager.model.ShareRequestAction.REVOKE
  }
}
