package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.IamArn
import scala.jdk.CollectionConverters.*
final case class Role(
    roleType: zio.aws.auditmanager.model.RoleType,
    roleArn: IamArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Role = {
    import Role.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Role
      .builder()
      .roleType(roleType.unwrap)
      .roleArn(IamArn.unwrap(roleArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Role.ReadOnly =
    zio.aws.auditmanager.model.Role.wrap(buildAwsValue())
}
object Role {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.auditmanager.model.Role] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Role =
      zio.aws.auditmanager.model.Role(roleType, roleArn)
    def roleType: zio.aws.auditmanager.model.RoleType
    def roleArn: IamArn
    def getRoleType: ZIO[Any, Nothing, zio.aws.auditmanager.model.RoleType] =
      ZIO.succeed(roleType)
    def getRoleArn: ZIO[Any, Nothing, IamArn] = ZIO.succeed(roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Role
  ) extends zio.aws.auditmanager.model.Role.ReadOnly {
    override val roleType: zio.aws.auditmanager.model.RoleType =
      zio.aws.auditmanager.model.RoleType.wrap(impl.roleType())
    override val roleArn: IamArn =
      zio.aws.auditmanager.model.primitives.IamArn(impl.roleArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Role
  ): zio.aws.auditmanager.model.Role.ReadOnly = new Wrapper(impl)
}
