package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters.*
final case class DeleteAssessmentFrameworkShareRequest(
    requestId: UUID,
    requestType: zio.aws.auditmanager.model.ShareRequestType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkShareRequest = {
    import DeleteAssessmentFrameworkShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkShareRequest
      .builder()
      .requestId(UUID.unwrap(requestId): java.lang.String)
      .requestType(requestType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.DeleteAssessmentFrameworkShareRequest.ReadOnly =
    zio.aws.auditmanager.model.DeleteAssessmentFrameworkShareRequest
      .wrap(buildAwsValue())
}
object DeleteAssessmentFrameworkShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.DeleteAssessmentFrameworkShareRequest =
      zio.aws.auditmanager.model
        .DeleteAssessmentFrameworkShareRequest(requestId, requestType)
    def requestId: UUID
    def requestType: zio.aws.auditmanager.model.ShareRequestType
    def getRequestId: ZIO[Any, Nothing, UUID] = ZIO.succeed(requestId)
    def getRequestType
        : ZIO[Any, Nothing, zio.aws.auditmanager.model.ShareRequestType] =
      ZIO.succeed(requestType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkShareRequest
  ) extends zio.aws.auditmanager.model.DeleteAssessmentFrameworkShareRequest.ReadOnly {
    override val requestId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.requestId())
    override val requestType: zio.aws.auditmanager.model.ShareRequestType =
      zio.aws.auditmanager.model.ShareRequestType.wrap(impl.requestType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkShareRequest
  ): zio.aws.auditmanager.model.DeleteAssessmentFrameworkShareRequest.ReadOnly =
    new Wrapper(impl)
}
