package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartAssessmentFrameworkShareResponse(
    assessmentFrameworkShareRequest: Optional[
      zio.aws.auditmanager.model.AssessmentFrameworkShareRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareResponse = {
    import StartAssessmentFrameworkShareResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareResponse
      .builder()
      .optionallyWith(
        assessmentFrameworkShareRequest.map(value => value.buildAwsValue())
      )(_.assessmentFrameworkShareRequest)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.StartAssessmentFrameworkShareResponse.ReadOnly =
    zio.aws.auditmanager.model.StartAssessmentFrameworkShareResponse
      .wrap(buildAwsValue())
}
object StartAssessmentFrameworkShareResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.StartAssessmentFrameworkShareResponse =
      zio.aws.auditmanager.model.StartAssessmentFrameworkShareResponse(
        assessmentFrameworkShareRequest.map(value => value.asEditable)
      )
    def assessmentFrameworkShareRequest: Optional[
      zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly
    ]
    def getAssessmentFrameworkShareRequest: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "assessmentFrameworkShareRequest",
      assessmentFrameworkShareRequest
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareResponse
  ) extends zio.aws.auditmanager.model.StartAssessmentFrameworkShareResponse.ReadOnly {
    override val assessmentFrameworkShareRequest: Optional[
      zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.assessmentFrameworkShareRequest())
      .map(value =>
        zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareResponse
  ): zio.aws.auditmanager.model.StartAssessmentFrameworkShareResponse.ReadOnly =
    new Wrapper(impl)
}
