package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Scope(
    awsAccounts: Optional[Iterable[zio.aws.auditmanager.model.AWSAccount]] =
      Optional.Absent,
    awsServices: Optional[Iterable[zio.aws.auditmanager.model.AWSService]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Scope = {
    import Scope.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Scope
      .builder()
      .optionallyWith(
        awsAccounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.awsAccounts)
      .optionallyWith(
        awsServices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.awsServices)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Scope.ReadOnly =
    zio.aws.auditmanager.model.Scope.wrap(buildAwsValue())
}
object Scope {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Scope
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Scope =
      zio.aws.auditmanager.model.Scope(
        awsAccounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        awsServices.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def awsAccounts
        : Optional[List[zio.aws.auditmanager.model.AWSAccount.ReadOnly]]
    def awsServices
        : Optional[List[zio.aws.auditmanager.model.AWSService.ReadOnly]]
    def getAwsAccounts: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.AWSAccount.ReadOnly
    ]] = AwsError.unwrapOptionField("awsAccounts", awsAccounts)
    def getAwsServices: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.AWSService.ReadOnly
    ]] = AwsError.unwrapOptionField("awsServices", awsServices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Scope
  ) extends zio.aws.auditmanager.model.Scope.ReadOnly {
    override val awsAccounts
        : Optional[List[zio.aws.auditmanager.model.AWSAccount.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsAccounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.AWSAccount.wrap(item)
          }.toList
        )
    override val awsServices
        : Optional[List[zio.aws.auditmanager.model.AWSService.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsServices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.AWSService.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Scope
  ): zio.aws.auditmanager.model.Scope.ReadOnly = new Wrapper(impl)
}
