package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.UUID
import scala.jdk.CollectionConverters.*
final case class GetControlRequest(controlId: UUID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetControlRequest = {
    import GetControlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetControlRequest
      .builder()
      .controlId(UUID.unwrap(controlId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.GetControlRequest.ReadOnly =
    zio.aws.auditmanager.model.GetControlRequest.wrap(buildAwsValue())
}
object GetControlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetControlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetControlRequest =
      zio.aws.auditmanager.model.GetControlRequest(controlId)
    def controlId: UUID
    def getControlId: ZIO[Any, Nothing, UUID] = ZIO.succeed(controlId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetControlRequest
  ) extends zio.aws.auditmanager.model.GetControlRequest.ReadOnly {
    override val controlId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.controlId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetControlRequest
  ): zio.aws.auditmanager.model.GetControlRequest.ReadOnly = new Wrapper(impl)
}
