package zio.aws.auditmanager.model
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.NullableInteger
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class EvidenceInsights(
    noncompliantEvidenceCount: Optional[NullableInteger] = Optional.Absent,
    compliantEvidenceCount: Optional[NullableInteger] = Optional.Absent,
    inconclusiveEvidenceCount: Optional[NullableInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.EvidenceInsights = {
    import EvidenceInsights.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.EvidenceInsights
      .builder()
      .optionallyWith(noncompliantEvidenceCount.map(value => value: Integer))(
        _.noncompliantEvidenceCount
      )
      .optionallyWith(compliantEvidenceCount.map(value => value: Integer))(
        _.compliantEvidenceCount
      )
      .optionallyWith(inconclusiveEvidenceCount.map(value => value: Integer))(
        _.inconclusiveEvidenceCount
      )
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.EvidenceInsights.ReadOnly =
    zio.aws.auditmanager.model.EvidenceInsights.wrap(buildAwsValue())
}
object EvidenceInsights {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.EvidenceInsights
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.EvidenceInsights =
      zio.aws.auditmanager.model.EvidenceInsights(
        noncompliantEvidenceCount.map(value => value),
        compliantEvidenceCount.map(value => value),
        inconclusiveEvidenceCount.map(value => value)
      )
    def noncompliantEvidenceCount: Optional[NullableInteger]
    def compliantEvidenceCount: Optional[NullableInteger]
    def inconclusiveEvidenceCount: Optional[NullableInteger]
    def getNoncompliantEvidenceCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "noncompliantEvidenceCount",
        noncompliantEvidenceCount
      )
    def getCompliantEvidenceCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "compliantEvidenceCount",
        compliantEvidenceCount
      )
    def getInconclusiveEvidenceCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "inconclusiveEvidenceCount",
        inconclusiveEvidenceCount
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.EvidenceInsights
  ) extends zio.aws.auditmanager.model.EvidenceInsights.ReadOnly {
    override val noncompliantEvidenceCount: Optional[NullableInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noncompliantEvidenceCount())
        .map(value => value: NullableInteger)
    override val compliantEvidenceCount: Optional[NullableInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compliantEvidenceCount())
        .map(value => value: NullableInteger)
    override val inconclusiveEvidenceCount: Optional[NullableInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inconclusiveEvidenceCount())
        .map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.EvidenceInsights
  ): zio.aws.auditmanager.model.EvidenceInsights.ReadOnly = new Wrapper(impl)
}
