package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateAssessmentControlResponse(
    control: Optional[zio.aws.auditmanager.model.AssessmentControl] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlResponse = {
    import UpdateAssessmentControlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlResponse
      .builder()
      .optionallyWith(control.map(value => value.buildAwsValue()))(_.control)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.UpdateAssessmentControlResponse.ReadOnly =
    zio.aws.auditmanager.model.UpdateAssessmentControlResponse
      .wrap(buildAwsValue())
}
object UpdateAssessmentControlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.UpdateAssessmentControlResponse =
      zio.aws.auditmanager.model
        .UpdateAssessmentControlResponse(control.map(value => value.asEditable))
    def control: Optional[zio.aws.auditmanager.model.AssessmentControl.ReadOnly]
    def getControl: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.AssessmentControl.ReadOnly
    ] = AwsError.unwrapOptionField("control", control)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlResponse
  ) extends zio.aws.auditmanager.model.UpdateAssessmentControlResponse.ReadOnly {
    override val control
        : Optional[zio.aws.auditmanager.model.AssessmentControl.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.control())
        .map(value => zio.aws.auditmanager.model.AssessmentControl.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlResponse
  ): zio.aws.auditmanager.model.UpdateAssessmentControlResponse.ReadOnly =
    new Wrapper(impl)
}
