package zio.aws.auditmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{
  Timestamp,
  ControlCommentBody,
  Username
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ControlComment(
    authorName: Optional[Username] = Optional.Absent,
    commentBody: Optional[ControlCommentBody] = Optional.Absent,
    postedDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ControlComment = {
    import ControlComment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ControlComment
      .builder()
      .optionallyWith(
        authorName.map(value => Username.unwrap(value): java.lang.String)
      )(_.authorName)
      .optionallyWith(
        commentBody.map(value =>
          ControlCommentBody.unwrap(value): java.lang.String
        )
      )(_.commentBody)
      .optionallyWith(
        postedDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.postedDate)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ControlComment.ReadOnly =
    zio.aws.auditmanager.model.ControlComment.wrap(buildAwsValue())
}
object ControlComment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ControlComment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ControlComment =
      zio.aws.auditmanager.model.ControlComment(
        authorName.map(value => value),
        commentBody.map(value => value),
        postedDate.map(value => value)
      )
    def authorName: Optional[Username]
    def commentBody: Optional[ControlCommentBody]
    def postedDate: Optional[Timestamp]
    def getAuthorName: ZIO[Any, AwsError, Username] =
      AwsError.unwrapOptionField("authorName", authorName)
    def getCommentBody: ZIO[Any, AwsError, ControlCommentBody] =
      AwsError.unwrapOptionField("commentBody", commentBody)
    def getPostedDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("postedDate", postedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlComment
  ) extends zio.aws.auditmanager.model.ControlComment.ReadOnly {
    override val authorName: Optional[Username] = zio.aws.core.internal
      .optionalFromNullable(impl.authorName())
      .map(value => zio.aws.auditmanager.model.primitives.Username(value))
    override val commentBody: Optional[ControlCommentBody] =
      zio.aws.core.internal
        .optionalFromNullable(impl.commentBody())
        .map(value =>
          zio.aws.auditmanager.model.primitives.ControlCommentBody(value)
        )
    override val postedDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.postedDate())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlComment
  ): zio.aws.auditmanager.model.ControlComment.ReadOnly = new Wrapper(impl)
}
