package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{ErrorMessage, ErrorCode}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchImportEvidenceToAssessmentControlError(
    manualEvidence: Optional[zio.aws.auditmanager.model.ManualEvidence] =
      Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlError = {
    import BatchImportEvidenceToAssessmentControlError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlError
      .builder()
      .optionallyWith(manualEvidence.map(value => value.buildAwsValue()))(
        _.manualEvidence
      )
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlError.ReadOnly =
    zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlError
      .wrap(buildAwsValue())
}
object BatchImportEvidenceToAssessmentControlError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlError =
      zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlError(
        manualEvidence.map(value => value.asEditable),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def manualEvidence
        : Optional[zio.aws.auditmanager.model.ManualEvidence.ReadOnly]
    def errorCode: Optional[ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def getManualEvidence: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.ManualEvidence.ReadOnly
    ] = AwsError.unwrapOptionField("manualEvidence", manualEvidence)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlError
  ) extends zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlError.ReadOnly {
    override val manualEvidence
        : Optional[zio.aws.auditmanager.model.ManualEvidence.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manualEvidence())
        .map(value => zio.aws.auditmanager.model.ManualEvidence.wrap(value))
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.auditmanager.model.primitives.ErrorCode(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.auditmanager.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlError
  ): zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlError.ReadOnly =
    new Wrapper(impl)
}
