package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateAssessmentFrameworkShareResponse(
    assessmentFrameworkShareRequest: Optional[
      zio.aws.auditmanager.model.AssessmentFrameworkShareRequest
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareResponse = {
    import UpdateAssessmentFrameworkShareResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareResponse
      .builder()
      .optionallyWith(
        assessmentFrameworkShareRequest.map(value => value.buildAwsValue())
      )(_.assessmentFrameworkShareRequest)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareResponse.ReadOnly =
    zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareResponse
      .wrap(buildAwsValue())
}
object UpdateAssessmentFrameworkShareResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareResponse =
      zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareResponse(
        assessmentFrameworkShareRequest.map(value => value.asEditable)
      )
    def assessmentFrameworkShareRequest: Optional[
      zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly
    ]
    def getAssessmentFrameworkShareRequest: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly
    ] = AwsError.unwrapOptionField(
      "assessmentFrameworkShareRequest",
      assessmentFrameworkShareRequest
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareResponse
  ) extends zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareResponse.ReadOnly {
    override val assessmentFrameworkShareRequest: Optional[
      zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.assessmentFrameworkShareRequest())
      .map(value =>
        zio.aws.auditmanager.model.AssessmentFrameworkShareRequest.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareResponse
  ): zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareResponse.ReadOnly =
    new Wrapper(impl)
}
