package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{Token, KeywordValue}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListKeywordsForDataSourceResponse(
    keywords: Optional[Iterable[KeywordValue]] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse = {
    import ListKeywordsForDataSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse
      .builder()
      .optionallyWith(
        keywords.map(value =>
          value.map { item =>
            KeywordValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.keywords)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse.ReadOnly =
    zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse
      .wrap(buildAwsValue())
}
object ListKeywordsForDataSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse =
      zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse(
        keywords.map(value => value),
        nextToken.map(value => value)
      )
    def keywords: Optional[List[KeywordValue]]
    def nextToken: Optional[Token]
    def getKeywords: ZIO[Any, AwsError, List[KeywordValue]] =
      AwsError.unwrapOptionField("keywords", keywords)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse
  ) extends zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse.ReadOnly {
    override val keywords: Optional[List[KeywordValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.keywords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.primitives.KeywordValue(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceResponse
  ): zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse.ReadOnly =
    new Wrapper(impl)
}
