package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{OrganizationId, AccountId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetOrganizationAdminAccountResponse(
    adminAccountId: Optional[AccountId] = Optional.Absent,
    organizationId: Optional[OrganizationId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetOrganizationAdminAccountResponse = {
    import GetOrganizationAdminAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetOrganizationAdminAccountResponse
      .builder()
      .optionallyWith(
        adminAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.adminAccountId)
      .optionallyWith(
        organizationId.map(value =>
          OrganizationId.unwrap(value): java.lang.String
        )
      )(_.organizationId)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetOrganizationAdminAccountResponse.ReadOnly =
    zio.aws.auditmanager.model.GetOrganizationAdminAccountResponse
      .wrap(buildAwsValue())
}
object GetOrganizationAdminAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetOrganizationAdminAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.GetOrganizationAdminAccountResponse =
      zio.aws.auditmanager.model.GetOrganizationAdminAccountResponse(
        adminAccountId.map(value => value),
        organizationId.map(value => value)
      )
    def adminAccountId: Optional[AccountId]
    def organizationId: Optional[OrganizationId]
    def getAdminAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("adminAccountId", adminAccountId)
    def getOrganizationId: ZIO[Any, AwsError, OrganizationId] =
      AwsError.unwrapOptionField("organizationId", organizationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetOrganizationAdminAccountResponse
  ) extends zio.aws.auditmanager.model.GetOrganizationAdminAccountResponse.ReadOnly {
    override val adminAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.adminAccountId())
      .map(value => zio.aws.auditmanager.model.primitives.AccountId(value))
    override val organizationId: Optional[OrganizationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationId())
        .map(value =>
          zio.aws.auditmanager.model.primitives.OrganizationId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetOrganizationAdminAccountResponse
  ): zio.aws.auditmanager.model.GetOrganizationAdminAccountResponse.ReadOnly =
    new Wrapper(impl)
}
