package zio.aws.auditmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{
  EventName,
  EvidenceAttributeKey,
  AccountId,
  AWSServiceName,
  Timestamp,
  EvidenceAttributeValue,
  IamArn,
  UUID
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Evidence(
    dataSource: Optional[String] = Optional.Absent,
    evidenceAwsAccountId: Optional[AccountId] = Optional.Absent,
    time: Optional[Timestamp] = Optional.Absent,
    eventSource: Optional[AWSServiceName] = Optional.Absent,
    eventName: Optional[EventName] = Optional.Absent,
    evidenceByType: Optional[String] = Optional.Absent,
    resourcesIncluded: Optional[Iterable[zio.aws.auditmanager.model.Resource]] =
      Optional.Absent,
    attributes: Optional[Map[EvidenceAttributeKey, EvidenceAttributeValue]] =
      Optional.Absent,
    iamId: Optional[IamArn] = Optional.Absent,
    complianceCheck: Optional[String] = Optional.Absent,
    awsOrganization: Optional[String] = Optional.Absent,
    awsAccountId: Optional[AccountId] = Optional.Absent,
    evidenceFolderId: Optional[UUID] = Optional.Absent,
    id: Optional[UUID] = Optional.Absent,
    assessmentReportSelection: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Evidence = {
    import Evidence.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Evidence
      .builder()
      .optionallyWith(dataSource.map(value => value: java.lang.String))(
        _.dataSource
      )
      .optionallyWith(
        evidenceAwsAccountId.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.evidenceAwsAccountId)
      .optionallyWith(time.map(value => Timestamp.unwrap(value): Instant))(
        _.time
      )
      .optionallyWith(
        eventSource.map(value => AWSServiceName.unwrap(value): java.lang.String)
      )(_.eventSource)
      .optionallyWith(
        eventName.map(value => EventName.unwrap(value): java.lang.String)
      )(_.eventName)
      .optionallyWith(evidenceByType.map(value => value: java.lang.String))(
        _.evidenceByType
      )
      .optionallyWith(
        resourcesIncluded.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourcesIncluded)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (EvidenceAttributeKey.unwrap(
                key
              ): java.lang.String) -> (EvidenceAttributeValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        iamId.map(value => IamArn.unwrap(value): java.lang.String)
      )(_.iamId)
      .optionallyWith(complianceCheck.map(value => value: java.lang.String))(
        _.complianceCheck
      )
      .optionallyWith(awsOrganization.map(value => value: java.lang.String))(
        _.awsOrganization
      )
      .optionallyWith(
        awsAccountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.awsAccountId)
      .optionallyWith(
        evidenceFolderId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.evidenceFolderId)
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        assessmentReportSelection.map(value => value: java.lang.String)
      )(_.assessmentReportSelection)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Evidence.ReadOnly =
    zio.aws.auditmanager.model.Evidence.wrap(buildAwsValue())
}
object Evidence {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Evidence
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Evidence =
      zio.aws.auditmanager.model.Evidence(
        dataSource.map(value => value),
        evidenceAwsAccountId.map(value => value),
        time.map(value => value),
        eventSource.map(value => value),
        eventName.map(value => value),
        evidenceByType.map(value => value),
        resourcesIncluded.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attributes.map(value => value),
        iamId.map(value => value),
        complianceCheck.map(value => value),
        awsOrganization.map(value => value),
        awsAccountId.map(value => value),
        evidenceFolderId.map(value => value),
        id.map(value => value),
        assessmentReportSelection.map(value => value)
      )
    def dataSource: Optional[String]
    def evidenceAwsAccountId: Optional[AccountId]
    def time: Optional[Timestamp]
    def eventSource: Optional[AWSServiceName]
    def eventName: Optional[EventName]
    def evidenceByType: Optional[String]
    def resourcesIncluded
        : Optional[List[zio.aws.auditmanager.model.Resource.ReadOnly]]
    def attributes: Optional[Map[EvidenceAttributeKey, EvidenceAttributeValue]]
    def iamId: Optional[IamArn]
    def complianceCheck: Optional[String]
    def awsOrganization: Optional[String]
    def awsAccountId: Optional[AccountId]
    def evidenceFolderId: Optional[UUID]
    def id: Optional[UUID]
    def assessmentReportSelection: Optional[String]
    def getDataSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataSource", dataSource)
    def getEvidenceAwsAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("evidenceAwsAccountId", evidenceAwsAccountId)
    def getTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("time", time)
    def getEventSource: ZIO[Any, AwsError, AWSServiceName] =
      AwsError.unwrapOptionField("eventSource", eventSource)
    def getEventName: ZIO[Any, AwsError, EventName] =
      AwsError.unwrapOptionField("eventName", eventName)
    def getEvidenceByType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("evidenceByType", evidenceByType)
    def getResourcesIncluded: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.Resource.ReadOnly
    ]] = AwsError.unwrapOptionField("resourcesIncluded", resourcesIncluded)
    def getAttributes: ZIO[Any, AwsError, Map[
      EvidenceAttributeKey,
      EvidenceAttributeValue
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getIamId: ZIO[Any, AwsError, IamArn] =
      AwsError.unwrapOptionField("iamId", iamId)
    def getComplianceCheck: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("complianceCheck", complianceCheck)
    def getAwsOrganization: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("awsOrganization", awsOrganization)
    def getAwsAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getEvidenceFolderId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("evidenceFolderId", evidenceFolderId)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getAssessmentReportSelection: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("assessmentReportSelection", assessmentReportSelection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Evidence
  ) extends zio.aws.auditmanager.model.Evidence.ReadOnly {
    override val dataSource: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dataSource())
      .map(value => value: String)
    override val evidenceAwsAccountId: Optional[AccountId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidenceAwsAccountId())
        .map(value => zio.aws.auditmanager.model.primitives.AccountId(value))
    override val time: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.time())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val eventSource: Optional[AWSServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.eventSource())
      .map(value => zio.aws.auditmanager.model.primitives.AWSServiceName(value))
    override val eventName: Optional[EventName] = zio.aws.core.internal
      .optionalFromNullable(impl.eventName())
      .map(value => zio.aws.auditmanager.model.primitives.EventName(value))
    override val evidenceByType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.evidenceByType())
      .map(value => value: String)
    override val resourcesIncluded
        : Optional[List[zio.aws.auditmanager.model.Resource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourcesIncluded())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.Resource.wrap(item)
          }.toList
        )
    override val attributes
        : Optional[Map[EvidenceAttributeKey, EvidenceAttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.auditmanager.model.primitives.EvidenceAttributeKey(
                key
              ) -> zio.aws.auditmanager.model.primitives
                .EvidenceAttributeValue(value)
            })
            .toMap
        )
    override val iamId: Optional[IamArn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamId())
      .map(value => zio.aws.auditmanager.model.primitives.IamArn(value))
    override val complianceCheck: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.complianceCheck())
      .map(value => value: String)
    override val awsOrganization: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.awsOrganization())
      .map(value => value: String)
    override val awsAccountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.awsAccountId())
      .map(value => zio.aws.auditmanager.model.primitives.AccountId(value))
    override val evidenceFolderId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.evidenceFolderId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val assessmentReportSelection: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assessmentReportSelection())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Evidence
  ): zio.aws.auditmanager.model.Evidence.ReadOnly = new Wrapper(impl)
}
