package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  ShareRequestComment,
  Region,
  AccountId,
  UUID
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartAssessmentFrameworkShareRequest(
    frameworkId: UUID,
    destinationAccount: AccountId,
    destinationRegion: Region,
    comment: Optional[ShareRequestComment] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareRequest = {
    import StartAssessmentFrameworkShareRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareRequest
      .builder()
      .frameworkId(UUID.unwrap(frameworkId): java.lang.String)
      .destinationAccount(
        AccountId.unwrap(destinationAccount): java.lang.String
      )
      .destinationRegion(Region.unwrap(destinationRegion): java.lang.String)
      .optionallyWith(
        comment.map(value =>
          ShareRequestComment.unwrap(value): java.lang.String
        )
      )(_.comment)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.StartAssessmentFrameworkShareRequest.ReadOnly =
    zio.aws.auditmanager.model.StartAssessmentFrameworkShareRequest
      .wrap(buildAwsValue())
}
object StartAssessmentFrameworkShareRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.StartAssessmentFrameworkShareRequest =
      zio.aws.auditmanager.model.StartAssessmentFrameworkShareRequest(
        frameworkId,
        destinationAccount,
        destinationRegion,
        comment.map(value => value)
      )
    def frameworkId: UUID
    def destinationAccount: AccountId
    def destinationRegion: Region
    def comment: Optional[ShareRequestComment]
    def getFrameworkId: ZIO[Any, Nothing, UUID] = ZIO.succeed(frameworkId)
    def getDestinationAccount: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(destinationAccount)
    def getDestinationRegion: ZIO[Any, Nothing, Region] =
      ZIO.succeed(destinationRegion)
    def getComment: ZIO[Any, AwsError, ShareRequestComment] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareRequest
  ) extends zio.aws.auditmanager.model.StartAssessmentFrameworkShareRequest.ReadOnly {
    override val frameworkId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.frameworkId())
    override val destinationAccount: AccountId =
      zio.aws.auditmanager.model.primitives.AccountId(impl.destinationAccount())
    override val destinationRegion: Region =
      zio.aws.auditmanager.model.primitives.Region(impl.destinationRegion())
    override val comment: Optional[ShareRequestComment] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value =>
        zio.aws.auditmanager.model.primitives.ShareRequestComment(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareRequest
  ): zio.aws.auditmanager.model.StartAssessmentFrameworkShareRequest.ReadOnly =
    new Wrapper(impl)
}
