package zio.aws.auditmanager.model
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{MaxResults, Token, UUID}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAssessmentControlInsightsByControlDomainRequest(
    controlDomainId: UUID,
    assessmentId: UUID,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest = {
    import ListAssessmentControlInsightsByControlDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest
      .builder()
      .controlDomainId(UUID.unwrap(controlDomainId): java.lang.String)
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest.ReadOnly =
    zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest
      .wrap(buildAwsValue())
}
object ListAssessmentControlInsightsByControlDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest =
      zio.aws.auditmanager.model
        .ListAssessmentControlInsightsByControlDomainRequest(
          controlDomainId,
          assessmentId,
          nextToken.map(value => value),
          maxResults.map(value => value)
        )
    def controlDomainId: UUID
    def assessmentId: UUID
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxResults]
    def getControlDomainId: ZIO[Any, Nothing, UUID] =
      ZIO.succeed(controlDomainId)
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest
  ) extends zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest.ReadOnly {
    override val controlDomainId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.controlDomainId())
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.auditmanager.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest
  ): zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest.ReadOnly =
    new Wrapper(impl)
}
