package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.S3Url
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssessmentReportsDestination(
    destinationType: Optional[
      zio.aws.auditmanager.model.AssessmentReportDestinationType
    ] = Optional.Absent,
    destination: Optional[S3Url] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssessmentReportsDestination = {
    import AssessmentReportsDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssessmentReportsDestination
      .builder()
      .optionallyWith(destinationType.map(value => value.unwrap))(
        _.destinationType
      )
      .optionallyWith(
        destination.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.destination)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.AssessmentReportsDestination.ReadOnly =
    zio.aws.auditmanager.model.AssessmentReportsDestination
      .wrap(buildAwsValue())
}
object AssessmentReportsDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssessmentReportsDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AssessmentReportsDestination =
      zio.aws.auditmanager.model.AssessmentReportsDestination(
        destinationType.map(value => value),
        destination.map(value => value)
      )
    def destinationType
        : Optional[zio.aws.auditmanager.model.AssessmentReportDestinationType]
    def destination: Optional[S3Url]
    def getDestinationType: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.AssessmentReportDestinationType
    ] = AwsError.unwrapOptionField("destinationType", destinationType)
    def getDestination: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("destination", destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentReportsDestination
  ) extends zio.aws.auditmanager.model.AssessmentReportsDestination.ReadOnly {
    override val destinationType
        : Optional[zio.aws.auditmanager.model.AssessmentReportDestinationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationType())
        .map(value =>
          zio.aws.auditmanager.model.AssessmentReportDestinationType.wrap(value)
        )
    override val destination: Optional[S3Url] = zio.aws.core.internal
      .optionalFromNullable(impl.destination())
      .map(value => zio.aws.auditmanager.model.primitives.S3Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentReportsDestination
  ): zio.aws.auditmanager.model.AssessmentReportsDestination.ReadOnly =
    new Wrapper(impl)
}
