package zio.aws.auditmanager
import zio.prelude.Subtype
import zio.aws.auditmanager.model.primitives.{
  EvidenceAttributeKey,
  KeywordValue,
  TagValue,
  EvidenceAttributeValue,
  UUID,
  NonEmptyString,
  TagKey
}
import java.time.Instant
import zio.aws.auditmanager.model.primitives.TroubleshootingText.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AWSServiceName extends Subtype[String]
    type AWSServiceName =
      zio.aws.auditmanager.model.primitives.AWSServiceName.Type
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.auditmanager.model.primitives.AccountId.Type
    object AccountName extends Subtype[String]
    type AccountName = zio.aws.auditmanager.model.primitives.AccountName.Type
    object ActionPlanInstructions extends Subtype[String]
    type ActionPlanInstructions =
      zio.aws.auditmanager.model.primitives.ActionPlanInstructions.Type
    object ActionPlanTitle extends Subtype[String]
    type ActionPlanTitle =
      zio.aws.auditmanager.model.primitives.ActionPlanTitle.Type
    object AssessmentDescription extends Subtype[String]
    type AssessmentDescription =
      zio.aws.auditmanager.model.primitives.AssessmentDescription.Type
    object AssessmentEvidenceFolderName extends Subtype[String]
    type AssessmentEvidenceFolderName =
      zio.aws.auditmanager.model.primitives.AssessmentEvidenceFolderName.Type
    object AssessmentFrameworkDescription extends Subtype[String]
    type AssessmentFrameworkDescription =
      zio.aws.auditmanager.model.primitives.AssessmentFrameworkDescription.Type
    object AssessmentName extends Subtype[String]
    type AssessmentName =
      zio.aws.auditmanager.model.primitives.AssessmentName.Type
    object AssessmentReportDescription extends Subtype[String]
    type AssessmentReportDescription =
      zio.aws.auditmanager.model.primitives.AssessmentReportDescription.Type
    object AssessmentReportName extends Subtype[String]
    type AssessmentReportName =
      zio.aws.auditmanager.model.primitives.AssessmentReportName.Type
    object AuditManagerArn extends Subtype[String]
    type AuditManagerArn =
      zio.aws.auditmanager.model.primitives.AuditManagerArn.Type
    object ComplianceType extends Subtype[String]
    type ComplianceType =
      zio.aws.auditmanager.model.primitives.ComplianceType.Type
    object ControlCommentBody extends Subtype[String]
    type ControlCommentBody =
      zio.aws.auditmanager.model.primitives.ControlCommentBody.Type
    object ControlDescription extends Subtype[String]
    type ControlDescription =
      zio.aws.auditmanager.model.primitives.ControlDescription.Type
    object ControlName extends Subtype[String]
    type ControlName = zio.aws.auditmanager.model.primitives.ControlName.Type
    object ControlSetId extends Subtype[String]
    type ControlSetId = zio.aws.auditmanager.model.primitives.ControlSetId.Type
    object ControlSetName extends Subtype[String]
    type ControlSetName =
      zio.aws.auditmanager.model.primitives.ControlSetName.Type
    object ControlSetsCount extends Subtype[Int]
    type ControlSetsCount =
      zio.aws.auditmanager.model.primitives.ControlSetsCount.Type
    object ControlSources extends Subtype[String]
    type ControlSources =
      zio.aws.auditmanager.model.primitives.ControlSources.Type
    object ControlsCount extends Subtype[Int]
    type ControlsCount =
      zio.aws.auditmanager.model.primitives.ControlsCount.Type
    object CreatedBy extends Subtype[String]
    type CreatedBy = zio.aws.auditmanager.model.primitives.CreatedBy.Type
    object DelegationComment extends Subtype[String]
    type DelegationComment =
      zio.aws.auditmanager.model.primitives.DelegationComment.Type
    object EmailAddress extends Subtype[String]
    type EmailAddress = zio.aws.auditmanager.model.primitives.EmailAddress.Type
    object ErrorCode extends Subtype[String]
    type ErrorCode = zio.aws.auditmanager.model.primitives.ErrorCode.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.auditmanager.model.primitives.ErrorMessage.Type
    object EventName extends Subtype[String]
    type EventName = zio.aws.auditmanager.model.primitives.EventName.Type
    object EvidenceAttributeKey extends Subtype[String]
    type EvidenceAttributeKey =
      zio.aws.auditmanager.model.primitives.EvidenceAttributeKey.Type
    object EvidenceAttributeValue extends Subtype[String]
    type EvidenceAttributeValue =
      zio.aws.auditmanager.model.primitives.EvidenceAttributeValue.Type
    object Filename extends Subtype[String]
    type Filename = zio.aws.auditmanager.model.primitives.Filename.Type
    object FrameworkDescription extends Subtype[String]
    type FrameworkDescription =
      zio.aws.auditmanager.model.primitives.FrameworkDescription.Type
    object FrameworkName extends Subtype[String]
    type FrameworkName =
      zio.aws.auditmanager.model.primitives.FrameworkName.Type
    object GenericArn extends Subtype[String]
    type GenericArn = zio.aws.auditmanager.model.primitives.GenericArn.Type
    object HyperlinkName extends Subtype[String]
    type HyperlinkName =
      zio.aws.auditmanager.model.primitives.HyperlinkName.Type
    object IamArn extends Subtype[String]
    type IamArn = zio.aws.auditmanager.model.primitives.IamArn.Type
    type Integer = Int
    object KeywordValue extends Subtype[String]
    type KeywordValue = zio.aws.auditmanager.model.primitives.KeywordValue.Type
    object KmsKey extends Subtype[String]
    type KmsKey = zio.aws.auditmanager.model.primitives.KmsKey.Type
    object LastUpdatedBy extends Subtype[String]
    type LastUpdatedBy =
      zio.aws.auditmanager.model.primitives.LastUpdatedBy.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.auditmanager.model.primitives.MaxResults.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString =
      zio.aws.auditmanager.model.primitives.NonEmptyString.Type
    type NullableInteger = Int
    object OrganizationId extends Subtype[String]
    type OrganizationId =
      zio.aws.auditmanager.model.primitives.OrganizationId.Type
    object Region extends Subtype[String]
    type Region = zio.aws.auditmanager.model.primitives.Region.Type
    object S3Url extends Subtype[String]
    type S3Url = zio.aws.auditmanager.model.primitives.S3Url.Type
    object SNSTopic extends Subtype[String]
    type SNSTopic = zio.aws.auditmanager.model.primitives.SNSTopic.Type
    object ShareRequestComment extends Subtype[String]
    type ShareRequestComment =
      zio.aws.auditmanager.model.primitives.ShareRequestComment.Type
    object SnsArn extends Subtype[String]
    type SnsArn = zio.aws.auditmanager.model.primitives.SnsArn.Type
    object SourceDescription extends Subtype[String]
    type SourceDescription =
      zio.aws.auditmanager.model.primitives.SourceDescription.Type
    object SourceName extends Subtype[String]
    type SourceName = zio.aws.auditmanager.model.primitives.SourceName.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.auditmanager.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.auditmanager.model.primitives.TagValue.Type
    object TestingInformation extends Subtype[String]
    type TestingInformation =
      zio.aws.auditmanager.model.primitives.TestingInformation.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.auditmanager.model.primitives.Timestamp.Type
    object TimestampUUID extends Subtype[String]
    type TimestampUUID =
      zio.aws.auditmanager.model.primitives.TimestampUUID.Type
    object Token extends Subtype[String]
    type Token = zio.aws.auditmanager.model.primitives.Token.Type
    object TroubleshootingText extends Subtype[String]
    type TroubleshootingText =
      zio.aws.auditmanager.model.primitives.TroubleshootingText.Type
    object UUID extends Subtype[String]
    type UUID = zio.aws.auditmanager.model.primitives.UUID.Type
    object UrlLink extends Subtype[String]
    type UrlLink = zio.aws.auditmanager.model.primitives.UrlLink.Type
    object Username extends Subtype[String]
    type Username = zio.aws.auditmanager.model.primitives.Username.Type
  }
  type AWSAccounts = List[zio.aws.auditmanager.model.AWSAccount]
  type AWSServices = List[zio.aws.auditmanager.model.AWSService]
  type AssessmentControlSets =
    List[zio.aws.auditmanager.model.AssessmentControlSet]
  type AssessmentControls = List[zio.aws.auditmanager.model.AssessmentControl]
  type AssessmentEvidenceFolders =
    List[zio.aws.auditmanager.model.AssessmentEvidenceFolder]
  type AssessmentFrameworkShareRequestList =
    List[zio.aws.auditmanager.model.AssessmentFrameworkShareRequest]
  type AssessmentReportEvidenceErrors =
    List[zio.aws.auditmanager.model.AssessmentReportEvidenceError]
  type AssessmentReportsMetadata =
    List[zio.aws.auditmanager.model.AssessmentReportMetadata]
  type BatchCreateDelegationByAssessmentErrors =
    List[zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError]
  type BatchDeleteDelegationByAssessmentErrors =
    List[zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentError]
  type BatchImportEvidenceToAssessmentControlErrors =
    List[zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlError]
  type ChangeLogs = List[zio.aws.auditmanager.model.ChangeLog]
  type ControlComments = List[zio.aws.auditmanager.model.ControlComment]
  type ControlDomainInsightsList =
    List[zio.aws.auditmanager.model.ControlDomainInsights]
  type ControlInsightsMetadata =
    List[zio.aws.auditmanager.model.ControlInsightsMetadataItem]
  type ControlInsightsMetadataByAssessment =
    List[zio.aws.auditmanager.model.ControlInsightsMetadataByAssessmentItem]
  type ControlMappingSources =
    List[zio.aws.auditmanager.model.ControlMappingSource]
  type ControlMetadataList = List[zio.aws.auditmanager.model.ControlMetadata]
  type ControlSets = List[zio.aws.auditmanager.model.ControlSet]
  type Controls = List[zio.aws.auditmanager.model.Control]
  type CreateAssessmentFrameworkControlSets =
    List[zio.aws.auditmanager.model.CreateAssessmentFrameworkControlSet]
  type CreateAssessmentFrameworkControls =
    List[zio.aws.auditmanager.model.CreateAssessmentFrameworkControl]
  type CreateControlMappingSources =
    List[zio.aws.auditmanager.model.CreateControlMappingSource]
  type CreateDelegationRequests =
    List[zio.aws.auditmanager.model.CreateDelegationRequest]
  type DelegationIds = List[UUID]
  type DelegationMetadataList =
    List[zio.aws.auditmanager.model.DelegationMetadata]
  type Delegations = List[zio.aws.auditmanager.model.Delegation]
  type EvidenceAttributes = Map[EvidenceAttributeKey, EvidenceAttributeValue]
  type EvidenceIds = List[UUID]
  type EvidenceList = List[zio.aws.auditmanager.model.Evidence]
  type EvidenceSources = List[NonEmptyString]
  type FrameworkMetadataList =
    List[zio.aws.auditmanager.model.AssessmentFrameworkMetadata]
  type Keywords = List[KeywordValue]
  type ListAssessmentMetadata =
    List[zio.aws.auditmanager.model.AssessmentMetadataItem]
  type ManualEvidenceList = List[zio.aws.auditmanager.model.ManualEvidence]
  type Notifications = List[zio.aws.auditmanager.model.Notification]
  type Resources = List[zio.aws.auditmanager.model.Resource]
  type Roles = List[zio.aws.auditmanager.model.Role]
  type ServiceMetadataList = List[zio.aws.auditmanager.model.ServiceMetadata]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type UpdateAssessmentFrameworkControlSets =
    List[zio.aws.auditmanager.model.UpdateAssessmentFrameworkControlSet]
  type ValidationErrors = List[NonEmptyString]
}
