package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetEvidenceFoldersByAssessmentResponse(
    evidenceFolders: Optional[
      Iterable[zio.aws.auditmanager.model.AssessmentEvidenceFolder]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse = {
    import GetEvidenceFoldersByAssessmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse
      .builder()
      .optionallyWith(
        evidenceFolders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.evidenceFolders)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentResponse.ReadOnly =
    zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentResponse
      .wrap(buildAwsValue())
}
object GetEvidenceFoldersByAssessmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentResponse =
      zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentResponse(
        evidenceFolders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def evidenceFolders: Optional[
      List[zio.aws.auditmanager.model.AssessmentEvidenceFolder.ReadOnly]
    ]
    def nextToken: Optional[Token]
    def getEvidenceFolders: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.AssessmentEvidenceFolder.ReadOnly
    ]] = AwsError.unwrapOptionField("evidenceFolders", evidenceFolders)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse
  ) extends zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentResponse.ReadOnly {
    override val evidenceFolders: Optional[
      List[zio.aws.auditmanager.model.AssessmentEvidenceFolder.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.evidenceFolders())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.AssessmentEvidenceFolder.wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentResponse
  ): zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentResponse.ReadOnly =
    new Wrapper(impl)
}
