package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{ControlSetName, UUID}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ControlSet(
    id: Optional[UUID] = Optional.Absent,
    name: Optional[ControlSetName] = Optional.Absent,
    controls: Optional[Iterable[zio.aws.auditmanager.model.Control]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ControlSet = {
    import ControlSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ControlSet
      .builder()
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => ControlSetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        controls.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controls)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ControlSet.ReadOnly =
    zio.aws.auditmanager.model.ControlSet.wrap(buildAwsValue())
}
object ControlSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ControlSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ControlSet =
      zio.aws.auditmanager.model.ControlSet(
        id.map(value => value),
        name.map(value => value),
        controls.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def id: Optional[UUID]
    def name: Optional[ControlSetName]
    def controls: Optional[List[zio.aws.auditmanager.model.Control.ReadOnly]]
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ControlSetName] =
      AwsError.unwrapOptionField("name", name)
    def getControls: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.Control.ReadOnly
    ]] = AwsError.unwrapOptionField("controls", controls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlSet
  ) extends zio.aws.auditmanager.model.ControlSet.ReadOnly {
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val name: Optional[ControlSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.ControlSetName(value))
    override val controls
        : Optional[List[zio.aws.auditmanager.model.Control.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controls())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.Control.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlSet
  ): zio.aws.auditmanager.model.ControlSet.ReadOnly = new Wrapper(impl)
}
