package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{ErrorMessage, ErrorCode, UUID}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssessmentReportEvidenceError(
    evidenceId: Optional[UUID] = Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssessmentReportEvidenceError = {
    import AssessmentReportEvidenceError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssessmentReportEvidenceError
      .builder()
      .optionallyWith(
        evidenceId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.evidenceId)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.AssessmentReportEvidenceError.ReadOnly =
    zio.aws.auditmanager.model.AssessmentReportEvidenceError
      .wrap(buildAwsValue())
}
object AssessmentReportEvidenceError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssessmentReportEvidenceError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AssessmentReportEvidenceError =
      zio.aws.auditmanager.model.AssessmentReportEvidenceError(
        evidenceId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def evidenceId: Optional[UUID]
    def errorCode: Optional[ErrorCode]
    def errorMessage: Optional[ErrorMessage]
    def getEvidenceId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("evidenceId", evidenceId)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentReportEvidenceError
  ) extends zio.aws.auditmanager.model.AssessmentReportEvidenceError.ReadOnly {
    override val evidenceId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.evidenceId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.auditmanager.model.primitives.ErrorCode(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.auditmanager.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentReportEvidenceError
  ): zio.aws.auditmanager.model.AssessmentReportEvidenceError.ReadOnly =
    new Wrapper(impl)
}
