package zio.aws.auditmanager
import zio.aws.auditmanager.model.GetAssessmentResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.auditmanager.model.{
  GetDelegationsRequest,
  DeleteControlRequest,
  GetAccountStatusRequest,
  BatchCreateDelegationByAssessmentRequest,
  BatchAssociateAssessmentReportEvidenceRequest,
  GetInsightsByAssessmentRequest,
  DeleteAssessmentReportRequest,
  UpdateSettingsRequest,
  CreateControlRequest,
  BatchDisassociateAssessmentReportEvidenceRequest,
  GetOrganizationAdminAccountRequest,
  ListKeywordsForDataSourceRequest,
  UpdateAssessmentControlSetStatusRequest,
  RegisterOrganizationAdminAccountRequest,
  GetAssessmentRequest,
  GetInsightsRequest,
  GetEvidenceByEvidenceFolderRequest,
  ListNotificationsRequest,
  GetServicesInScopeRequest,
  ListTagsForResourceRequest,
  RegisterAccountRequest,
  UpdateAssessmentFrameworkRequest,
  ListAssessmentsRequest,
  GetEvidenceRequest,
  UpdateAssessmentStatusRequest,
  ListControlInsightsByControlDomainRequest,
  GetChangeLogsRequest,
  UpdateAssessmentRequest,
  DeleteAssessmentRequest,
  CreateAssessmentFrameworkRequest,
  GetSettingsRequest,
  ListControlDomainInsightsByAssessmentRequest,
  ListControlsRequest,
  CreateAssessmentReportRequest,
  GetAssessmentFrameworkRequest,
  ListAssessmentControlInsightsByControlDomainRequest,
  ListAssessmentFrameworksRequest,
  GetControlRequest,
  CreateAssessmentRequest,
  GetEvidenceFoldersByAssessmentRequest,
  ListControlDomainInsightsRequest,
  UntagResourceRequest,
  ListAssessmentFrameworkShareRequestsRequest,
  DeregisterAccountRequest,
  GetEvidenceFolderRequest,
  UpdateControlRequest,
  BatchImportEvidenceToAssessmentControlRequest,
  BatchDeleteDelegationByAssessmentRequest,
  StartAssessmentFrameworkShareRequest,
  ValidateAssessmentReportIntegrityRequest,
  UpdateAssessmentControlRequest,
  AssociateAssessmentReportEvidenceFolderRequest,
  DeleteAssessmentFrameworkShareRequest,
  GetAssessmentReportUrlRequest,
  DeregisterOrganizationAdminAccountRequest,
  DeleteAssessmentFrameworkRequest,
  ListAssessmentReportsRequest,
  GetEvidenceFoldersByAssessmentControlRequest,
  TagResourceRequest,
  UpdateAssessmentFrameworkShareRequest,
  DisassociateAssessmentReportEvidenceFolderRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.auditmanager.{
  AuditManagerAsyncClientBuilder,
  AuditManagerAsyncClient
}
import software.amazon.awssdk.services.auditmanager.model.{
  DeleteAssessmentFrameworkShareResponse,
  ListKeywordsForDataSourceResponse,
  ListControlInsightsByControlDomainResponse,
  GetSettingsResponse,
  DeleteAssessmentReportResponse,
  BatchImportEvidenceToAssessmentControlResponse,
  DeregisterOrganizationAdminAccountResponse,
  DeleteControlResponse,
  CreateAssessmentResponse,
  GetAccountStatusResponse,
  GetEvidenceResponse,
  GetInsightsByAssessmentResponse,
  BatchDisassociateAssessmentReportEvidenceResponse,
  GetAssessmentResponse,
  ListControlDomainInsightsResponse,
  UpdateAssessmentResponse,
  StartAssessmentFrameworkShareResponse,
  GetEvidenceByEvidenceFolderResponse,
  DeleteAssessmentResponse,
  RegisterOrganizationAdminAccountResponse,
  BatchDeleteDelegationByAssessmentResponse,
  ListAssessmentFrameworkShareRequestsResponse,
  GetControlResponse,
  UpdateAssessmentFrameworkResponse,
  CreateAssessmentReportResponse,
  DisassociateAssessmentReportEvidenceFolderResponse,
  GetDelegationsResponse,
  UpdateAssessmentControlResponse,
  ListTagsForResourceResponse,
  UpdateSettingsResponse,
  UpdateAssessmentStatusResponse,
  UntagResourceResponse,
  RegisterAccountResponse,
  GetAssessmentFrameworkResponse,
  CreateControlResponse,
  ListAssessmentFrameworksResponse,
  ListAssessmentReportsResponse,
  BatchCreateDelegationByAssessmentResponse,
  GetChangeLogsResponse,
  GetEvidenceFoldersByAssessmentResponse,
  ValidateAssessmentReportIntegrityResponse,
  GetEvidenceFolderResponse,
  UpdateAssessmentControlSetStatusResponse,
  BatchAssociateAssessmentReportEvidenceResponse,
  GetAssessmentReportUrlResponse,
  ListControlDomainInsightsByAssessmentResponse,
  ListNotificationsResponse,
  UpdateAssessmentFrameworkShareResponse,
  CreateAssessmentFrameworkResponse,
  GetServicesInScopeResponse,
  ListAssessmentControlInsightsByControlDomainResponse,
  TagResourceResponse,
  DeleteAssessmentFrameworkResponse,
  ListAssessmentsResponse,
  UpdateControlResponse,
  DeregisterAccountResponse,
  GetInsightsResponse,
  AssociateAssessmentReportEvidenceFolderResponse,
  ListControlsResponse,
  GetOrganizationAdminAccountResponse,
  GetEvidenceFoldersByAssessmentControlResponse
}
import scala.jdk.CollectionConverters.*
trait AuditManager extends AspectSupport[AuditManager] {
  val api: AuditManagerAsyncClient
  def listKeywordsForDataSource(request: ListKeywordsForDataSourceRequest): IO[
    AwsError,
    zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse.ReadOnly
  ]
  def updateAssessmentStatus(request: UpdateAssessmentStatusRequest): IO[
    AwsError,
    zio.aws.auditmanager.model.UpdateAssessmentStatusResponse.ReadOnly
  ]
  def batchDisassociateAssessmentReportEvidence(
      request: BatchDisassociateAssessmentReportEvidenceRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse.ReadOnly
  ]
  def batchCreateDelegationByAssessment(
      request: BatchCreateDelegationByAssessmentRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse.ReadOnly
  ]
  def createControl(
      request: CreateControlRequest
  ): IO[AwsError, zio.aws.auditmanager.model.CreateControlResponse.ReadOnly]
  def createAssessment(
      request: CreateAssessmentRequest
  ): IO[AwsError, zio.aws.auditmanager.model.CreateAssessmentResponse.ReadOnly]
  def getSettings(
      request: GetSettingsRequest
  ): IO[AwsError, zio.aws.auditmanager.model.GetSettingsResponse.ReadOnly]
  def listControls(
      request: ListControlsRequest
  ): IO[AwsError, zio.aws.auditmanager.model.ListControlsResponse.ReadOnly]
  def listControlInsightsByControlDomain(
      request: ListControlInsightsByControlDomainRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.ListControlInsightsByControlDomainResponse.ReadOnly
  ]
  def getInsights(
      request: GetInsightsRequest
  ): IO[AwsError, zio.aws.auditmanager.model.GetInsightsResponse.ReadOnly]
  def registerAccount(
      request: RegisterAccountRequest
  ): IO[AwsError, zio.aws.auditmanager.model.RegisterAccountResponse.ReadOnly]
  def getAssessmentReportUrl(request: GetAssessmentReportUrlRequest): IO[
    AwsError,
    zio.aws.auditmanager.model.GetAssessmentReportUrlResponse.ReadOnly
  ]
  def listNotifications(
      request: ListNotificationsRequest
  ): IO[AwsError, zio.aws.auditmanager.model.ListNotificationsResponse.ReadOnly]
  def getServicesInScope(request: GetServicesInScopeRequest): IO[
    AwsError,
    zio.aws.auditmanager.model.GetServicesInScopeResponse.ReadOnly
  ]
  def listControlDomainInsightsByAssessment(
      request: ListControlDomainInsightsByAssessmentRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.ListControlDomainInsightsByAssessmentResponse.ReadOnly
  ]
  def getAccountStatus(
      request: GetAccountStatusRequest
  ): IO[AwsError, zio.aws.auditmanager.model.GetAccountStatusResponse.ReadOnly]
  def updateAssessment(
      request: UpdateAssessmentRequest
  ): IO[AwsError, zio.aws.auditmanager.model.UpdateAssessmentResponse.ReadOnly]
  def batchImportEvidenceToAssessmentControl(
      request: BatchImportEvidenceToAssessmentControlRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse.ReadOnly
  ]
  def getEvidence(
      request: GetEvidenceRequest
  ): IO[AwsError, zio.aws.auditmanager.model.GetEvidenceResponse.ReadOnly]
  def updateAssessmentControlSetStatus(
      request: UpdateAssessmentControlSetStatusRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusResponse.ReadOnly
  ]
  def getAssessmentFramework(request: GetAssessmentFrameworkRequest): IO[
    AwsError,
    zio.aws.auditmanager.model.GetAssessmentFrameworkResponse.ReadOnly
  ]
  def deleteAssessmentFramework(request: DeleteAssessmentFrameworkRequest): IO[
    AwsError,
    zio.aws.auditmanager.model.DeleteAssessmentFrameworkResponse.ReadOnly
  ]
  def listAssessmentFrameworks(request: ListAssessmentFrameworksRequest): IO[
    AwsError,
    zio.aws.auditmanager.model.ListAssessmentFrameworksResponse.ReadOnly
  ]
  def deleteControl(
      request: DeleteControlRequest
  ): IO[AwsError, zio.aws.auditmanager.model.DeleteControlResponse.ReadOnly]
  def getChangeLogs(
      request: GetChangeLogsRequest
  ): IO[AwsError, zio.aws.auditmanager.model.GetChangeLogsResponse.ReadOnly]
  def updateControl(
      request: UpdateControlRequest
  ): IO[AwsError, zio.aws.auditmanager.model.UpdateControlResponse.ReadOnly]
  def getControl(
      request: GetControlRequest
  ): IO[AwsError, zio.aws.auditmanager.model.GetControlResponse.ReadOnly]
  def validateAssessmentReportIntegrity(
      request: ValidateAssessmentReportIntegrityRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityResponse.ReadOnly
  ]
  def disassociateAssessmentReportEvidenceFolder(
      request: DisassociateAssessmentReportEvidenceFolderRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.DisassociateAssessmentReportEvidenceFolderResponse.ReadOnly
  ]
  def updateAssessmentFramework(request: UpdateAssessmentFrameworkRequest): IO[
    AwsError,
    zio.aws.auditmanager.model.UpdateAssessmentFrameworkResponse.ReadOnly
  ]
  def getDelegations(
      request: GetDelegationsRequest
  ): IO[AwsError, zio.aws.auditmanager.model.GetDelegationsResponse.ReadOnly]
  def getEvidenceByEvidenceFolder(
      request: GetEvidenceByEvidenceFolderRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.auditmanager.model.UntagResourceResponse.ReadOnly]
  def updateSettings(
      request: UpdateSettingsRequest
  ): IO[AwsError, zio.aws.auditmanager.model.UpdateSettingsResponse.ReadOnly]
  def deleteAssessmentReport(request: DeleteAssessmentReportRequest): IO[
    AwsError,
    zio.aws.auditmanager.model.DeleteAssessmentReportResponse.ReadOnly
  ]
  def getEvidenceFolder(
      request: GetEvidenceFolderRequest
  ): IO[AwsError, zio.aws.auditmanager.model.GetEvidenceFolderResponse.ReadOnly]
  def getAssessment(request: GetAssessmentRequest): IO[AwsError, ReadOnly]
  def startAssessmentFrameworkShare(
      request: StartAssessmentFrameworkShareRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.StartAssessmentFrameworkShareResponse.ReadOnly
  ]
  def createAssessmentReport(request: CreateAssessmentReportRequest): IO[
    AwsError,
    zio.aws.auditmanager.model.CreateAssessmentReportResponse.ReadOnly
  ]
  def getInsightsByAssessment(request: GetInsightsByAssessmentRequest): IO[
    AwsError,
    zio.aws.auditmanager.model.GetInsightsByAssessmentResponse.ReadOnly
  ]
  def updateAssessmentControl(request: UpdateAssessmentControlRequest): IO[
    AwsError,
    zio.aws.auditmanager.model.UpdateAssessmentControlResponse.ReadOnly
  ]
  def associateAssessmentReportEvidenceFolder(
      request: AssociateAssessmentReportEvidenceFolderRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.AssociateAssessmentReportEvidenceFolderResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.auditmanager.model.ListTagsForResourceResponse.ReadOnly
  ]
  def createAssessmentFramework(request: CreateAssessmentFrameworkRequest): IO[
    AwsError,
    zio.aws.auditmanager.model.CreateAssessmentFrameworkResponse.ReadOnly
  ]
  def deleteAssessmentFrameworkShare(
      request: DeleteAssessmentFrameworkShareRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.DeleteAssessmentFrameworkShareResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.auditmanager.model.TagResourceResponse.ReadOnly]
  def deregisterOrganizationAdminAccount(
      request: DeregisterOrganizationAdminAccountRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.DeregisterOrganizationAdminAccountResponse.ReadOnly
  ]
  def batchAssociateAssessmentReportEvidence(
      request: BatchAssociateAssessmentReportEvidenceRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.BatchAssociateAssessmentReportEvidenceResponse.ReadOnly
  ]
  def getEvidenceFoldersByAssessmentControl(
      request: GetEvidenceFoldersByAssessmentControlRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse.ReadOnly
  ]
  def deregisterAccount(
      request: DeregisterAccountRequest
  ): IO[AwsError, zio.aws.auditmanager.model.DeregisterAccountResponse.ReadOnly]
  def listAssessmentReports(request: ListAssessmentReportsRequest): IO[
    AwsError,
    zio.aws.auditmanager.model.ListAssessmentReportsResponse.ReadOnly
  ]
  def getOrganizationAdminAccount(
      request: GetOrganizationAdminAccountRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.GetOrganizationAdminAccountResponse.ReadOnly
  ]
  def batchDeleteDelegationByAssessment(
      request: BatchDeleteDelegationByAssessmentRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentResponse.ReadOnly
  ]
  def deleteAssessment(
      request: DeleteAssessmentRequest
  ): IO[AwsError, zio.aws.auditmanager.model.DeleteAssessmentResponse.ReadOnly]
  def listAssessmentControlInsightsByControlDomain(
      request: ListAssessmentControlInsightsByControlDomainRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse.ReadOnly
  ]
  def getEvidenceFoldersByAssessment(
      request: GetEvidenceFoldersByAssessmentRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentResponse.ReadOnly
  ]
  def registerOrganizationAdminAccount(
      request: RegisterOrganizationAdminAccountRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.RegisterOrganizationAdminAccountResponse.ReadOnly
  ]
  def listAssessments(
      request: ListAssessmentsRequest
  ): IO[AwsError, zio.aws.auditmanager.model.ListAssessmentsResponse.ReadOnly]
  def updateAssessmentFrameworkShare(
      request: UpdateAssessmentFrameworkShareRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareResponse.ReadOnly
  ]
  def listControlDomainInsights(request: ListControlDomainInsightsRequest): IO[
    AwsError,
    zio.aws.auditmanager.model.ListControlDomainInsightsResponse.ReadOnly
  ]
  def listAssessmentFrameworkShareRequests(
      request: ListAssessmentFrameworkShareRequestsRequest
  ): IO[
    AwsError,
    zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse.ReadOnly
  ]
}
object AuditManager {
  val live: ZLayer[AwsConfig, java.lang.Throwable, AuditManager] = customized(
    identity
  )
  def customized(
      customization: AuditManagerAsyncClientBuilder => AuditManagerAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, AuditManager] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: AuditManagerAsyncClientBuilder => AuditManagerAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, AuditManager] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = AuditManagerAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[AuditManagerAsyncClient, AuditManagerAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      AuditManagerAsyncClient,
      AuditManagerAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new AuditManagerImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class AuditManagerImpl[R](
      override val api: AuditManagerAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends AuditManager
      with AwsServiceBase[R] {
    override val serviceName: String = "AuditManager"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AuditManagerImpl[R1] = new AuditManagerImpl(api, newAspect, r)
    def listKeywordsForDataSource(
        request: ListKeywordsForDataSourceRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.ListKeywordsForDataSourceRequest,
      ListKeywordsForDataSourceResponse
    ]("listKeywordsForDataSource", api.listKeywordsForDataSource)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse.wrap)
      .provideEnvironment(r)
    def updateAssessmentStatus(request: UpdateAssessmentStatusRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.UpdateAssessmentStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentStatusRequest,
      UpdateAssessmentStatusResponse
    ]("updateAssessmentStatus", api.updateAssessmentStatus)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.UpdateAssessmentStatusResponse.wrap)
      .provideEnvironment(r)
    def batchDisassociateAssessmentReportEvidence(
        request: BatchDisassociateAssessmentReportEvidenceRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.BatchDisassociateAssessmentReportEvidenceRequest,
      BatchDisassociateAssessmentReportEvidenceResponse
    ](
      "batchDisassociateAssessmentReportEvidence",
      api.batchDisassociateAssessmentReportEvidence
    )(request.buildAwsValue())
      .map(
        zio.aws.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse.wrap
      )
      .provideEnvironment(r)
    def batchCreateDelegationByAssessment(
        request: BatchCreateDelegationByAssessmentRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentRequest,
      BatchCreateDelegationByAssessmentResponse
    ](
      "batchCreateDelegationByAssessment",
      api.batchCreateDelegationByAssessment
    )(request.buildAwsValue())
      .map(
        zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse.wrap
      )
      .provideEnvironment(r)
    def createControl(
        request: CreateControlRequest
    ): IO[AwsError, zio.aws.auditmanager.model.CreateControlResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.auditmanager.model.CreateControlRequest,
        CreateControlResponse
      ]("createControl", api.createControl)(request.buildAwsValue())
        .map(zio.aws.auditmanager.model.CreateControlResponse.wrap)
        .provideEnvironment(r)
    def createAssessment(request: CreateAssessmentRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.CreateAssessmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.CreateAssessmentRequest,
      CreateAssessmentResponse
    ]("createAssessment", api.createAssessment)(request.buildAwsValue())
      .map(zio.aws.auditmanager.model.CreateAssessmentResponse.wrap)
      .provideEnvironment(r)
    def getSettings(
        request: GetSettingsRequest
    ): IO[AwsError, zio.aws.auditmanager.model.GetSettingsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.auditmanager.model.GetSettingsRequest,
        GetSettingsResponse
      ]("getSettings", api.getSettings)(request.buildAwsValue())
        .map(zio.aws.auditmanager.model.GetSettingsResponse.wrap)
        .provideEnvironment(r)
    def listControls(
        request: ListControlsRequest
    ): IO[AwsError, zio.aws.auditmanager.model.ListControlsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.auditmanager.model.ListControlsRequest,
        ListControlsResponse
      ]("listControls", api.listControls)(request.buildAwsValue())
        .map(zio.aws.auditmanager.model.ListControlsResponse.wrap)
        .provideEnvironment(r)
    def listControlInsightsByControlDomain(
        request: ListControlInsightsByControlDomainRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.ListControlInsightsByControlDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest,
      ListControlInsightsByControlDomainResponse
    ](
      "listControlInsightsByControlDomain",
      api.listControlInsightsByControlDomain
    )(request.buildAwsValue())
      .map(
        zio.aws.auditmanager.model.ListControlInsightsByControlDomainResponse.wrap
      )
      .provideEnvironment(r)
    def getInsights(
        request: GetInsightsRequest
    ): IO[AwsError, zio.aws.auditmanager.model.GetInsightsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.auditmanager.model.GetInsightsRequest,
        GetInsightsResponse
      ]("getInsights", api.getInsights)(request.buildAwsValue())
        .map(zio.aws.auditmanager.model.GetInsightsResponse.wrap)
        .provideEnvironment(r)
    def registerAccount(request: RegisterAccountRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.RegisterAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.RegisterAccountRequest,
      RegisterAccountResponse
    ]("registerAccount", api.registerAccount)(request.buildAwsValue())
      .map(zio.aws.auditmanager.model.RegisterAccountResponse.wrap)
      .provideEnvironment(r)
    def getAssessmentReportUrl(request: GetAssessmentReportUrlRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.GetAssessmentReportUrlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.GetAssessmentReportUrlRequest,
      GetAssessmentReportUrlResponse
    ]("getAssessmentReportUrl", api.getAssessmentReportUrl)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.GetAssessmentReportUrlResponse.wrap)
      .provideEnvironment(r)
    def listNotifications(request: ListNotificationsRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.ListNotificationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.ListNotificationsRequest,
      ListNotificationsResponse
    ]("listNotifications", api.listNotifications)(request.buildAwsValue())
      .map(zio.aws.auditmanager.model.ListNotificationsResponse.wrap)
      .provideEnvironment(r)
    def getServicesInScope(request: GetServicesInScopeRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.GetServicesInScopeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.GetServicesInScopeRequest,
      GetServicesInScopeResponse
    ]("getServicesInScope", api.getServicesInScope)(request.buildAwsValue())
      .map(zio.aws.auditmanager.model.GetServicesInScopeResponse.wrap)
      .provideEnvironment(r)
    def listControlDomainInsightsByAssessment(
        request: ListControlDomainInsightsByAssessmentRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.ListControlDomainInsightsByAssessmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsByAssessmentRequest,
      ListControlDomainInsightsByAssessmentResponse
    ](
      "listControlDomainInsightsByAssessment",
      api.listControlDomainInsightsByAssessment
    )(request.buildAwsValue())
      .map(
        zio.aws.auditmanager.model.ListControlDomainInsightsByAssessmentResponse.wrap
      )
      .provideEnvironment(r)
    def getAccountStatus(request: GetAccountStatusRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.GetAccountStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.GetAccountStatusRequest,
      GetAccountStatusResponse
    ]("getAccountStatus", api.getAccountStatus)(request.buildAwsValue())
      .map(zio.aws.auditmanager.model.GetAccountStatusResponse.wrap)
      .provideEnvironment(r)
    def updateAssessment(request: UpdateAssessmentRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.UpdateAssessmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentRequest,
      UpdateAssessmentResponse
    ]("updateAssessment", api.updateAssessment)(request.buildAwsValue())
      .map(zio.aws.auditmanager.model.UpdateAssessmentResponse.wrap)
      .provideEnvironment(r)
    def batchImportEvidenceToAssessmentControl(
        request: BatchImportEvidenceToAssessmentControlRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.BatchImportEvidenceToAssessmentControlRequest,
      BatchImportEvidenceToAssessmentControlResponse
    ](
      "batchImportEvidenceToAssessmentControl",
      api.batchImportEvidenceToAssessmentControl
    )(request.buildAwsValue())
      .map(
        zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse.wrap
      )
      .provideEnvironment(r)
    def getEvidence(
        request: GetEvidenceRequest
    ): IO[AwsError, zio.aws.auditmanager.model.GetEvidenceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.auditmanager.model.GetEvidenceRequest,
        GetEvidenceResponse
      ]("getEvidence", api.getEvidence)(request.buildAwsValue())
        .map(zio.aws.auditmanager.model.GetEvidenceResponse.wrap)
        .provideEnvironment(r)
    def updateAssessmentControlSetStatus(
        request: UpdateAssessmentControlSetStatusRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlSetStatusRequest,
      UpdateAssessmentControlSetStatusResponse
    ]("updateAssessmentControlSetStatus", api.updateAssessmentControlSetStatus)(
      request.buildAwsValue()
    ).map(
      zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusResponse.wrap
    ).provideEnvironment(r)
    def getAssessmentFramework(request: GetAssessmentFrameworkRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.GetAssessmentFrameworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.GetAssessmentFrameworkRequest,
      GetAssessmentFrameworkResponse
    ]("getAssessmentFramework", api.getAssessmentFramework)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.GetAssessmentFrameworkResponse.wrap)
      .provideEnvironment(r)
    def deleteAssessmentFramework(
        request: DeleteAssessmentFrameworkRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.DeleteAssessmentFrameworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkRequest,
      DeleteAssessmentFrameworkResponse
    ]("deleteAssessmentFramework", api.deleteAssessmentFramework)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.DeleteAssessmentFrameworkResponse.wrap)
      .provideEnvironment(r)
    def listAssessmentFrameworks(request: ListAssessmentFrameworksRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.ListAssessmentFrameworksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworksRequest,
      ListAssessmentFrameworksResponse
    ]("listAssessmentFrameworks", api.listAssessmentFrameworks)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.ListAssessmentFrameworksResponse.wrap)
      .provideEnvironment(r)
    def deleteControl(
        request: DeleteControlRequest
    ): IO[AwsError, zio.aws.auditmanager.model.DeleteControlResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.auditmanager.model.DeleteControlRequest,
        DeleteControlResponse
      ]("deleteControl", api.deleteControl)(request.buildAwsValue())
        .map(zio.aws.auditmanager.model.DeleteControlResponse.wrap)
        .provideEnvironment(r)
    def getChangeLogs(
        request: GetChangeLogsRequest
    ): IO[AwsError, zio.aws.auditmanager.model.GetChangeLogsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.auditmanager.model.GetChangeLogsRequest,
        GetChangeLogsResponse
      ]("getChangeLogs", api.getChangeLogs)(request.buildAwsValue())
        .map(zio.aws.auditmanager.model.GetChangeLogsResponse.wrap)
        .provideEnvironment(r)
    def updateControl(
        request: UpdateControlRequest
    ): IO[AwsError, zio.aws.auditmanager.model.UpdateControlResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.auditmanager.model.UpdateControlRequest,
        UpdateControlResponse
      ]("updateControl", api.updateControl)(request.buildAwsValue())
        .map(zio.aws.auditmanager.model.UpdateControlResponse.wrap)
        .provideEnvironment(r)
    def getControl(
        request: GetControlRequest
    ): IO[AwsError, zio.aws.auditmanager.model.GetControlResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.auditmanager.model.GetControlRequest,
        GetControlResponse
      ]("getControl", api.getControl)(request.buildAwsValue())
        .map(zio.aws.auditmanager.model.GetControlResponse.wrap)
        .provideEnvironment(r)
    def validateAssessmentReportIntegrity(
        request: ValidateAssessmentReportIntegrityRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.ValidateAssessmentReportIntegrityRequest,
      ValidateAssessmentReportIntegrityResponse
    ](
      "validateAssessmentReportIntegrity",
      api.validateAssessmentReportIntegrity
    )(request.buildAwsValue())
      .map(
        zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityResponse.wrap
      )
      .provideEnvironment(r)
    def disassociateAssessmentReportEvidenceFolder(
        request: DisassociateAssessmentReportEvidenceFolderRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.DisassociateAssessmentReportEvidenceFolderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.DisassociateAssessmentReportEvidenceFolderRequest,
      DisassociateAssessmentReportEvidenceFolderResponse
    ](
      "disassociateAssessmentReportEvidenceFolder",
      api.disassociateAssessmentReportEvidenceFolder
    )(request.buildAwsValue())
      .map(
        zio.aws.auditmanager.model.DisassociateAssessmentReportEvidenceFolderResponse.wrap
      )
      .provideEnvironment(r)
    def updateAssessmentFramework(
        request: UpdateAssessmentFrameworkRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.UpdateAssessmentFrameworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkRequest,
      UpdateAssessmentFrameworkResponse
    ]("updateAssessmentFramework", api.updateAssessmentFramework)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.UpdateAssessmentFrameworkResponse.wrap)
      .provideEnvironment(r)
    def getDelegations(request: GetDelegationsRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.GetDelegationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.GetDelegationsRequest,
      GetDelegationsResponse
    ]("getDelegations", api.getDelegations)(request.buildAwsValue())
      .map(zio.aws.auditmanager.model.GetDelegationsResponse.wrap)
      .provideEnvironment(r)
    def getEvidenceByEvidenceFolder(
        request: GetEvidenceByEvidenceFolderRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderRequest,
      GetEvidenceByEvidenceFolderResponse
    ]("getEvidenceByEvidenceFolder", api.getEvidenceByEvidenceFolder)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.auditmanager.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.auditmanager.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.auditmanager.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateSettings(request: UpdateSettingsRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.UpdateSettingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.UpdateSettingsRequest,
      UpdateSettingsResponse
    ]("updateSettings", api.updateSettings)(request.buildAwsValue())
      .map(zio.aws.auditmanager.model.UpdateSettingsResponse.wrap)
      .provideEnvironment(r)
    def deleteAssessmentReport(request: DeleteAssessmentReportRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.DeleteAssessmentReportResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentReportRequest,
      DeleteAssessmentReportResponse
    ]("deleteAssessmentReport", api.deleteAssessmentReport)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.DeleteAssessmentReportResponse.wrap)
      .provideEnvironment(r)
    def getEvidenceFolder(request: GetEvidenceFolderRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.GetEvidenceFolderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderRequest,
      GetEvidenceFolderResponse
    ]("getEvidenceFolder", api.getEvidenceFolder)(request.buildAwsValue())
      .map(zio.aws.auditmanager.model.GetEvidenceFolderResponse.wrap)
      .provideEnvironment(r)
    def getAssessment(request: GetAssessmentRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.auditmanager.model.GetAssessmentRequest,
        GetAssessmentResponse
      ]("getAssessment", api.getAssessment)(request.buildAwsValue())
        .map(zio.aws.auditmanager.model.GetAssessmentResponse.wrap)
        .provideEnvironment(r)
    def startAssessmentFrameworkShare(
        request: StartAssessmentFrameworkShareRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.StartAssessmentFrameworkShareResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.StartAssessmentFrameworkShareRequest,
      StartAssessmentFrameworkShareResponse
    ]("startAssessmentFrameworkShare", api.startAssessmentFrameworkShare)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.StartAssessmentFrameworkShareResponse.wrap)
      .provideEnvironment(r)
    def createAssessmentReport(request: CreateAssessmentReportRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.CreateAssessmentReportResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.CreateAssessmentReportRequest,
      CreateAssessmentReportResponse
    ]("createAssessmentReport", api.createAssessmentReport)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.CreateAssessmentReportResponse.wrap)
      .provideEnvironment(r)
    def getInsightsByAssessment(request: GetInsightsByAssessmentRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.GetInsightsByAssessmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentRequest,
      GetInsightsByAssessmentResponse
    ]("getInsightsByAssessment", api.getInsightsByAssessment)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.GetInsightsByAssessmentResponse.wrap)
      .provideEnvironment(r)
    def updateAssessmentControl(request: UpdateAssessmentControlRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.UpdateAssessmentControlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlRequest,
      UpdateAssessmentControlResponse
    ]("updateAssessmentControl", api.updateAssessmentControl)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.UpdateAssessmentControlResponse.wrap)
      .provideEnvironment(r)
    def associateAssessmentReportEvidenceFolder(
        request: AssociateAssessmentReportEvidenceFolderRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.AssociateAssessmentReportEvidenceFolderResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.AssociateAssessmentReportEvidenceFolderRequest,
      AssociateAssessmentReportEvidenceFolderResponse
    ](
      "associateAssessmentReportEvidenceFolder",
      api.associateAssessmentReportEvidenceFolder
    )(request.buildAwsValue())
      .map(
        zio.aws.auditmanager.model.AssociateAssessmentReportEvidenceFolderResponse.wrap
      )
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.auditmanager.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def createAssessmentFramework(
        request: CreateAssessmentFrameworkRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.CreateAssessmentFrameworkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.CreateAssessmentFrameworkRequest,
      CreateAssessmentFrameworkResponse
    ]("createAssessmentFramework", api.createAssessmentFramework)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.CreateAssessmentFrameworkResponse.wrap)
      .provideEnvironment(r)
    def deleteAssessmentFrameworkShare(
        request: DeleteAssessmentFrameworkShareRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.DeleteAssessmentFrameworkShareResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentFrameworkShareRequest,
      DeleteAssessmentFrameworkShareResponse
    ]("deleteAssessmentFrameworkShare", api.deleteAssessmentFrameworkShare)(
      request.buildAwsValue()
    ).map(
      zio.aws.auditmanager.model.DeleteAssessmentFrameworkShareResponse.wrap
    ).provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.auditmanager.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.auditmanager.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.auditmanager.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def deregisterOrganizationAdminAccount(
        request: DeregisterOrganizationAdminAccountRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.DeregisterOrganizationAdminAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.DeregisterOrganizationAdminAccountRequest,
      DeregisterOrganizationAdminAccountResponse
    ](
      "deregisterOrganizationAdminAccount",
      api.deregisterOrganizationAdminAccount
    )(request.buildAwsValue())
      .map(
        zio.aws.auditmanager.model.DeregisterOrganizationAdminAccountResponse.wrap
      )
      .provideEnvironment(r)
    def batchAssociateAssessmentReportEvidence(
        request: BatchAssociateAssessmentReportEvidenceRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.BatchAssociateAssessmentReportEvidenceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.BatchAssociateAssessmentReportEvidenceRequest,
      BatchAssociateAssessmentReportEvidenceResponse
    ](
      "batchAssociateAssessmentReportEvidence",
      api.batchAssociateAssessmentReportEvidence
    )(request.buildAwsValue())
      .map(
        zio.aws.auditmanager.model.BatchAssociateAssessmentReportEvidenceResponse.wrap
      )
      .provideEnvironment(r)
    def getEvidenceFoldersByAssessmentControl(
        request: GetEvidenceFoldersByAssessmentControlRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest,
      GetEvidenceFoldersByAssessmentControlResponse
    ](
      "getEvidenceFoldersByAssessmentControl",
      api.getEvidenceFoldersByAssessmentControl
    )(request.buildAwsValue())
      .map(
        zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse.wrap
      )
      .provideEnvironment(r)
    def deregisterAccount(request: DeregisterAccountRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.DeregisterAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.DeregisterAccountRequest,
      DeregisterAccountResponse
    ]("deregisterAccount", api.deregisterAccount)(request.buildAwsValue())
      .map(zio.aws.auditmanager.model.DeregisterAccountResponse.wrap)
      .provideEnvironment(r)
    def listAssessmentReports(request: ListAssessmentReportsRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.ListAssessmentReportsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.ListAssessmentReportsRequest,
      ListAssessmentReportsResponse
    ]("listAssessmentReports", api.listAssessmentReports)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.ListAssessmentReportsResponse.wrap)
      .provideEnvironment(r)
    def getOrganizationAdminAccount(
        request: GetOrganizationAdminAccountRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.GetOrganizationAdminAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.GetOrganizationAdminAccountRequest,
      GetOrganizationAdminAccountResponse
    ]("getOrganizationAdminAccount", api.getOrganizationAdminAccount)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.GetOrganizationAdminAccountResponse.wrap)
      .provideEnvironment(r)
    def batchDeleteDelegationByAssessment(
        request: BatchDeleteDelegationByAssessmentRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.BatchDeleteDelegationByAssessmentRequest,
      BatchDeleteDelegationByAssessmentResponse
    ](
      "batchDeleteDelegationByAssessment",
      api.batchDeleteDelegationByAssessment
    )(request.buildAwsValue())
      .map(
        zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentResponse.wrap
      )
      .provideEnvironment(r)
    def deleteAssessment(request: DeleteAssessmentRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.DeleteAssessmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.DeleteAssessmentRequest,
      DeleteAssessmentResponse
    ]("deleteAssessment", api.deleteAssessment)(request.buildAwsValue())
      .map(zio.aws.auditmanager.model.DeleteAssessmentResponse.wrap)
      .provideEnvironment(r)
    def listAssessmentControlInsightsByControlDomain(
        request: ListAssessmentControlInsightsByControlDomainRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.ListAssessmentControlInsightsByControlDomainRequest,
      ListAssessmentControlInsightsByControlDomainResponse
    ](
      "listAssessmentControlInsightsByControlDomain",
      api.listAssessmentControlInsightsByControlDomain
    )(request.buildAwsValue())
      .map(
        zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse.wrap
      )
      .provideEnvironment(r)
    def getEvidenceFoldersByAssessment(
        request: GetEvidenceFoldersByAssessmentRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest,
      GetEvidenceFoldersByAssessmentResponse
    ]("getEvidenceFoldersByAssessment", api.getEvidenceFoldersByAssessment)(
      request.buildAwsValue()
    ).map(
      zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentResponse.wrap
    ).provideEnvironment(r)
    def registerOrganizationAdminAccount(
        request: RegisterOrganizationAdminAccountRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.RegisterOrganizationAdminAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.RegisterOrganizationAdminAccountRequest,
      RegisterOrganizationAdminAccountResponse
    ]("registerOrganizationAdminAccount", api.registerOrganizationAdminAccount)(
      request.buildAwsValue()
    ).map(
      zio.aws.auditmanager.model.RegisterOrganizationAdminAccountResponse.wrap
    ).provideEnvironment(r)
    def listAssessments(request: ListAssessmentsRequest): IO[
      AwsError,
      zio.aws.auditmanager.model.ListAssessmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.ListAssessmentsRequest,
      ListAssessmentsResponse
    ]("listAssessments", api.listAssessments)(request.buildAwsValue())
      .map(zio.aws.auditmanager.model.ListAssessmentsResponse.wrap)
      .provideEnvironment(r)
    def updateAssessmentFrameworkShare(
        request: UpdateAssessmentFrameworkShareRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentFrameworkShareRequest,
      UpdateAssessmentFrameworkShareResponse
    ]("updateAssessmentFrameworkShare", api.updateAssessmentFrameworkShare)(
      request.buildAwsValue()
    ).map(
      zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareResponse.wrap
    ).provideEnvironment(r)
    def listControlDomainInsights(
        request: ListControlDomainInsightsRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.ListControlDomainInsightsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.ListControlDomainInsightsRequest,
      ListControlDomainInsightsResponse
    ]("listControlDomainInsights", api.listControlDomainInsights)(
      request.buildAwsValue()
    ).map(zio.aws.auditmanager.model.ListControlDomainInsightsResponse.wrap)
      .provideEnvironment(r)
    def listAssessmentFrameworkShareRequests(
        request: ListAssessmentFrameworkShareRequestsRequest
    ): IO[
      AwsError,
      zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.auditmanager.model.ListAssessmentFrameworkShareRequestsRequest,
      ListAssessmentFrameworkShareRequestsResponse
    ](
      "listAssessmentFrameworkShareRequests",
      api.listAssessmentFrameworkShareRequests
    )(request.buildAwsValue())
      .map(
        zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse.wrap
      )
      .provideEnvironment(r)
  }
  def listKeywordsForDataSource(request: ListKeywordsForDataSourceRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.ListKeywordsForDataSourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listKeywordsForDataSource(request))
  def updateAssessmentStatus(request: UpdateAssessmentStatusRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.UpdateAssessmentStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAssessmentStatus(request))
  def batchDisassociateAssessmentReportEvidence(
      request: BatchDisassociateAssessmentReportEvidenceRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.BatchDisassociateAssessmentReportEvidenceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDisassociateAssessmentReportEvidence(request))
  def batchCreateDelegationByAssessment(
      request: BatchCreateDelegationByAssessmentRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchCreateDelegationByAssessment(request))
  def createControl(request: CreateControlRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.CreateControlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createControl(request))
  def createAssessment(request: CreateAssessmentRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.CreateAssessmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAssessment(request))
  def getSettings(request: GetSettingsRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.GetSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSettings(request))
  def listControls(request: ListControlsRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.ListControlsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listControls(request))
  def listControlInsightsByControlDomain(
      request: ListControlInsightsByControlDomainRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.ListControlInsightsByControlDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listControlInsightsByControlDomain(request))
  def getInsights(request: GetInsightsRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.GetInsightsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInsights(request))
  def registerAccount(request: RegisterAccountRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.RegisterAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerAccount(request))
  def getAssessmentReportUrl(request: GetAssessmentReportUrlRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.GetAssessmentReportUrlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAssessmentReportUrl(request))
  def listNotifications(request: ListNotificationsRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.ListNotificationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listNotifications(request))
  def getServicesInScope(request: GetServicesInScopeRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.GetServicesInScopeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServicesInScope(request))
  def listControlDomainInsightsByAssessment(
      request: ListControlDomainInsightsByAssessmentRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.ListControlDomainInsightsByAssessmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listControlDomainInsightsByAssessment(request))
  def getAccountStatus(request: GetAccountStatusRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.GetAccountStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccountStatus(request))
  def updateAssessment(request: UpdateAssessmentRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.UpdateAssessmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAssessment(request))
  def batchImportEvidenceToAssessmentControl(
      request: BatchImportEvidenceToAssessmentControlRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.BatchImportEvidenceToAssessmentControlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchImportEvidenceToAssessmentControl(request))
  def getEvidence(request: GetEvidenceRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.GetEvidenceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEvidence(request))
  def updateAssessmentControlSetStatus(
      request: UpdateAssessmentControlSetStatusRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.UpdateAssessmentControlSetStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAssessmentControlSetStatus(request))
  def getAssessmentFramework(request: GetAssessmentFrameworkRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.GetAssessmentFrameworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAssessmentFramework(request))
  def deleteAssessmentFramework(request: DeleteAssessmentFrameworkRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.DeleteAssessmentFrameworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAssessmentFramework(request))
  def listAssessmentFrameworks(request: ListAssessmentFrameworksRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.ListAssessmentFrameworksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssessmentFrameworks(request))
  def deleteControl(request: DeleteControlRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.DeleteControlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteControl(request))
  def getChangeLogs(request: GetChangeLogsRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.GetChangeLogsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getChangeLogs(request))
  def updateControl(request: UpdateControlRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.UpdateControlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateControl(request))
  def getControl(request: GetControlRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.GetControlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getControl(request))
  def validateAssessmentReportIntegrity(
      request: ValidateAssessmentReportIntegrityRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.ValidateAssessmentReportIntegrityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.validateAssessmentReportIntegrity(request))
  def disassociateAssessmentReportEvidenceFolder(
      request: DisassociateAssessmentReportEvidenceFolderRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.DisassociateAssessmentReportEvidenceFolderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateAssessmentReportEvidenceFolder(request))
  def updateAssessmentFramework(request: UpdateAssessmentFrameworkRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.UpdateAssessmentFrameworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAssessmentFramework(request))
  def getDelegations(request: GetDelegationsRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.GetDelegationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDelegations(request))
  def getEvidenceByEvidenceFolder(
      request: GetEvidenceByEvidenceFolderRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEvidenceByEvidenceFolder(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def updateSettings(request: UpdateSettingsRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.UpdateSettingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSettings(request))
  def deleteAssessmentReport(request: DeleteAssessmentReportRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.DeleteAssessmentReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAssessmentReport(request))
  def getEvidenceFolder(request: GetEvidenceFolderRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.GetEvidenceFolderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEvidenceFolder(request))
  def getAssessment(
      request: GetAssessmentRequest
  ): ZIO[zio.aws.auditmanager.AuditManager, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getAssessment(request))
  def startAssessmentFrameworkShare(
      request: StartAssessmentFrameworkShareRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.StartAssessmentFrameworkShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startAssessmentFrameworkShare(request))
  def createAssessmentReport(request: CreateAssessmentReportRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.CreateAssessmentReportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAssessmentReport(request))
  def getInsightsByAssessment(request: GetInsightsByAssessmentRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.GetInsightsByAssessmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getInsightsByAssessment(request))
  def updateAssessmentControl(request: UpdateAssessmentControlRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.UpdateAssessmentControlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAssessmentControl(request))
  def associateAssessmentReportEvidenceFolder(
      request: AssociateAssessmentReportEvidenceFolderRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.AssociateAssessmentReportEvidenceFolderResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateAssessmentReportEvidenceFolder(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def createAssessmentFramework(request: CreateAssessmentFrameworkRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.CreateAssessmentFrameworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAssessmentFramework(request))
  def deleteAssessmentFrameworkShare(
      request: DeleteAssessmentFrameworkShareRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.DeleteAssessmentFrameworkShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAssessmentFrameworkShare(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def deregisterOrganizationAdminAccount(
      request: DeregisterOrganizationAdminAccountRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.DeregisterOrganizationAdminAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterOrganizationAdminAccount(request))
  def batchAssociateAssessmentReportEvidence(
      request: BatchAssociateAssessmentReportEvidenceRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.BatchAssociateAssessmentReportEvidenceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchAssociateAssessmentReportEvidence(request))
  def getEvidenceFoldersByAssessmentControl(
      request: GetEvidenceFoldersByAssessmentControlRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEvidenceFoldersByAssessmentControl(request))
  def deregisterAccount(request: DeregisterAccountRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.DeregisterAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterAccount(request))
  def listAssessmentReports(request: ListAssessmentReportsRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.ListAssessmentReportsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssessmentReports(request))
  def getOrganizationAdminAccount(
      request: GetOrganizationAdminAccountRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.GetOrganizationAdminAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getOrganizationAdminAccount(request))
  def batchDeleteDelegationByAssessment(
      request: BatchDeleteDelegationByAssessmentRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.BatchDeleteDelegationByAssessmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchDeleteDelegationByAssessment(request))
  def deleteAssessment(request: DeleteAssessmentRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.DeleteAssessmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAssessment(request))
  def listAssessmentControlInsightsByControlDomain(
      request: ListAssessmentControlInsightsByControlDomainRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.ListAssessmentControlInsightsByControlDomainResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.listAssessmentControlInsightsByControlDomain(request))
  def getEvidenceFoldersByAssessment(
      request: GetEvidenceFoldersByAssessmentRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEvidenceFoldersByAssessment(request))
  def registerOrganizationAdminAccount(
      request: RegisterOrganizationAdminAccountRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.RegisterOrganizationAdminAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerOrganizationAdminAccount(request))
  def listAssessments(request: ListAssessmentsRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.ListAssessmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssessments(request))
  def updateAssessmentFrameworkShare(
      request: UpdateAssessmentFrameworkShareRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.UpdateAssessmentFrameworkShareResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAssessmentFrameworkShare(request))
  def listControlDomainInsights(request: ListControlDomainInsightsRequest): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.ListControlDomainInsightsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listControlDomainInsights(request))
  def listAssessmentFrameworkShareRequests(
      request: ListAssessmentFrameworkShareRequestsRequest
  ): ZIO[
    zio.aws.auditmanager.AuditManager,
    AwsError,
    zio.aws.auditmanager.model.ListAssessmentFrameworkShareRequestsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAssessmentFrameworkShareRequests(request))
}
