package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class RegisterOrganizationAdminAccountRequest(
    adminAccountId: AccountId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.RegisterOrganizationAdminAccountRequest = {
    import RegisterOrganizationAdminAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.RegisterOrganizationAdminAccountRequest
      .builder()
      .adminAccountId(AccountId.unwrap(adminAccountId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.RegisterOrganizationAdminAccountRequest.ReadOnly =
    zio.aws.auditmanager.model.RegisterOrganizationAdminAccountRequest
      .wrap(buildAwsValue())
}
object RegisterOrganizationAdminAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.RegisterOrganizationAdminAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.RegisterOrganizationAdminAccountRequest =
      zio.aws.auditmanager.model
        .RegisterOrganizationAdminAccountRequest(adminAccountId)
    def adminAccountId: AccountId
    def getAdminAccountId: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(adminAccountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.RegisterOrganizationAdminAccountRequest
  ) extends zio.aws.auditmanager.model.RegisterOrganizationAdminAccountRequest.ReadOnly {
    override val adminAccountId: AccountId =
      zio.aws.auditmanager.model.primitives.AccountId(impl.adminAccountId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.RegisterOrganizationAdminAccountRequest
  ): zio.aws.auditmanager.model.RegisterOrganizationAdminAccountRequest.ReadOnly =
    new Wrapper(impl)
}
