package zio.aws.auditmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{
  Timestamp,
  NullableInteger,
  UUID,
  NonEmptyString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ControlDomainInsights(
    name: Optional[NonEmptyString] = Optional.Absent,
    id: Optional[UUID] = Optional.Absent,
    controlsCountByNoncompliantEvidence: Optional[NullableInteger] =
      Optional.Absent,
    totalControlsCount: Optional[NullableInteger] = Optional.Absent,
    evidenceInsights: Optional[zio.aws.auditmanager.model.EvidenceInsights] =
      Optional.Absent,
    lastUpdated: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ControlDomainInsights = {
    import ControlDomainInsights.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ControlDomainInsights
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        controlsCountByNoncompliantEvidence.map(value => value: Integer)
      )(_.controlsCountByNoncompliantEvidence)
      .optionallyWith(totalControlsCount.map(value => value: Integer))(
        _.totalControlsCount
      )
      .optionallyWith(evidenceInsights.map(value => value.buildAwsValue()))(
        _.evidenceInsights
      )
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ControlDomainInsights.ReadOnly =
    zio.aws.auditmanager.model.ControlDomainInsights.wrap(buildAwsValue())
}
object ControlDomainInsights {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ControlDomainInsights
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ControlDomainInsights =
      zio.aws.auditmanager.model.ControlDomainInsights(
        name.map(value => value),
        id.map(value => value),
        controlsCountByNoncompliantEvidence.map(value => value),
        totalControlsCount.map(value => value),
        evidenceInsights.map(value => value.asEditable),
        lastUpdated.map(value => value)
      )
    def name: Optional[NonEmptyString]
    def id: Optional[UUID]
    def controlsCountByNoncompliantEvidence: Optional[NullableInteger]
    def totalControlsCount: Optional[NullableInteger]
    def evidenceInsights
        : Optional[zio.aws.auditmanager.model.EvidenceInsights.ReadOnly]
    def lastUpdated: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getControlsCountByNoncompliantEvidence
        : ZIO[Any, AwsError, NullableInteger] = AwsError.unwrapOptionField(
      "controlsCountByNoncompliantEvidence",
      controlsCountByNoncompliantEvidence
    )
    def getTotalControlsCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("totalControlsCount", totalControlsCount)
    def getEvidenceInsights: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.EvidenceInsights.ReadOnly
    ] = AwsError.unwrapOptionField("evidenceInsights", evidenceInsights)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlDomainInsights
  ) extends zio.aws.auditmanager.model.ControlDomainInsights.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val controlsCountByNoncompliantEvidence
        : Optional[NullableInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.controlsCountByNoncompliantEvidence())
      .map(value => value: NullableInteger)
    override val totalControlsCount: Optional[NullableInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalControlsCount())
        .map(value => value: NullableInteger)
    override val evidenceInsights
        : Optional[zio.aws.auditmanager.model.EvidenceInsights.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidenceInsights())
        .map(value => zio.aws.auditmanager.model.EvidenceInsights.wrap(value))
    override val lastUpdated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdated())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ControlDomainInsights
  ): zio.aws.auditmanager.model.ControlDomainInsights.ReadOnly = new Wrapper(
    impl
  )
}
