package zio.aws.auditmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  MaxResults,
  Token,
  ControlSetId,
  UUID
}
import scala.jdk.CollectionConverters.*
final case class GetEvidenceFoldersByAssessmentControlRequest(
    assessmentId: UUID,
    controlSetId: ControlSetId,
    controlId: UUID,
    nextToken: Option[Token] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest = {
    import GetEvidenceFoldersByAssessmentControlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .controlSetId(ControlSetId.unwrap(controlSetId): java.lang.String)
      .controlId(UUID.unwrap(controlId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest.ReadOnly =
    zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest
      .wrap(buildAwsValue())
}
object GetEvidenceFoldersByAssessmentControlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest =
      zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest(
        assessmentId,
        controlSetId,
        controlId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assessmentId: UUID
    def controlSetId: ControlSetId
    def controlId: UUID
    def nextToken: Option[Token]
    def maxResults: Option[MaxResults]
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
    def getControlSetId: ZIO[Any, Nothing, ControlSetId] =
      ZIO.succeed(controlSetId)
    def getControlId: ZIO[Any, Nothing, UUID] = ZIO.succeed(controlId)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest
  ) extends zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
    override val controlSetId: ControlSetId =
      zio.aws.auditmanager.model.primitives.ControlSetId(impl.controlSetId())
    override val controlId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.controlId())
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.auditmanager.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest
  ): zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentControlRequest.ReadOnly =
    new Wrapper(impl)
}
