package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.{ControlSetId, UUID}
import scala.jdk.CollectionConverters.*
final case class GetEvidenceFolderRequest(
    assessmentId: UUID,
    controlSetId: ControlSetId,
    evidenceFolderId: UUID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderRequest = {
    import GetEvidenceFolderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .controlSetId(ControlSetId.unwrap(controlSetId): java.lang.String)
      .evidenceFolderId(UUID.unwrap(evidenceFolderId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.GetEvidenceFolderRequest.ReadOnly =
    zio.aws.auditmanager.model.GetEvidenceFolderRequest.wrap(buildAwsValue())
}
object GetEvidenceFolderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetEvidenceFolderRequest =
      zio.aws.auditmanager.model
        .GetEvidenceFolderRequest(assessmentId, controlSetId, evidenceFolderId)
    def assessmentId: UUID
    def controlSetId: ControlSetId
    def evidenceFolderId: UUID
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
    def getControlSetId: ZIO[Any, Nothing, ControlSetId] =
      ZIO.succeed(controlSetId)
    def getEvidenceFolderId: ZIO[Any, Nothing, UUID] =
      ZIO.succeed(evidenceFolderId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderRequest
  ) extends zio.aws.auditmanager.model.GetEvidenceFolderRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
    override val controlSetId: ControlSetId =
      zio.aws.auditmanager.model.primitives.ControlSetId(impl.controlSetId())
    override val evidenceFolderId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.evidenceFolderId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceFolderRequest
  ): zio.aws.auditmanager.model.GetEvidenceFolderRequest.ReadOnly = new Wrapper(
    impl
  )
}
