package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.Token
import scala.jdk.CollectionConverters.*
final case class GetEvidenceByEvidenceFolderResponse(
    evidence: Option[Iterable[zio.aws.auditmanager.model.Evidence]] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse = {
    import GetEvidenceByEvidenceFolderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse
      .builder()
      .optionallyWith(
        evidence.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.evidence)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse.ReadOnly =
    zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse
      .wrap(buildAwsValue())
}
object GetEvidenceByEvidenceFolderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse =
      zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse(
        evidence.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def evidence: Option[List[zio.aws.auditmanager.model.Evidence.ReadOnly]]
    def nextToken: Option[Token]
    def getEvidence: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.Evidence.ReadOnly
    ]] = AwsError.unwrapOptionField("evidence", evidence)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse
  ) extends zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse.ReadOnly {
    override val evidence
        : Option[List[zio.aws.auditmanager.model.Evidence.ReadOnly]] = scala
      .Option(impl.evidence())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.Evidence.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceByEvidenceFolderResponse
  ): zio.aws.auditmanager.model.GetEvidenceByEvidenceFolderResponse.ReadOnly =
    new Wrapper(impl)
}
