package zio.aws.auditmanager.model
import java.time.Instant
import zio.aws.auditmanager.model.primitives.{Timestamp, NullableInteger}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class InsightsByAssessment(
    noncompliantEvidenceCount: Option[NullableInteger] = None,
    compliantEvidenceCount: Option[NullableInteger] = None,
    inconclusiveEvidenceCount: Option[NullableInteger] = None,
    assessmentControlsCountByNoncompliantEvidence: Option[NullableInteger] =
      None,
    totalAssessmentControlsCount: Option[NullableInteger] = None,
    lastUpdated: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.InsightsByAssessment = {
    import InsightsByAssessment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.InsightsByAssessment
      .builder()
      .optionallyWith(noncompliantEvidenceCount.map(value => value: Integer))(
        _.noncompliantEvidenceCount
      )
      .optionallyWith(compliantEvidenceCount.map(value => value: Integer))(
        _.compliantEvidenceCount
      )
      .optionallyWith(inconclusiveEvidenceCount.map(value => value: Integer))(
        _.inconclusiveEvidenceCount
      )
      .optionallyWith(
        assessmentControlsCountByNoncompliantEvidence.map(value =>
          value: Integer
        )
      )(_.assessmentControlsCountByNoncompliantEvidence)
      .optionallyWith(
        totalAssessmentControlsCount.map(value => value: Integer)
      )(_.totalAssessmentControlsCount)
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.InsightsByAssessment.ReadOnly =
    zio.aws.auditmanager.model.InsightsByAssessment.wrap(buildAwsValue())
}
object InsightsByAssessment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.InsightsByAssessment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.InsightsByAssessment =
      zio.aws.auditmanager.model.InsightsByAssessment(
        noncompliantEvidenceCount.map(value => value),
        compliantEvidenceCount.map(value => value),
        inconclusiveEvidenceCount.map(value => value),
        assessmentControlsCountByNoncompliantEvidence.map(value => value),
        totalAssessmentControlsCount.map(value => value),
        lastUpdated.map(value => value)
      )
    def noncompliantEvidenceCount: Option[NullableInteger]
    def compliantEvidenceCount: Option[NullableInteger]
    def inconclusiveEvidenceCount: Option[NullableInteger]
    def assessmentControlsCountByNoncompliantEvidence: Option[NullableInteger]
    def totalAssessmentControlsCount: Option[NullableInteger]
    def lastUpdated: Option[Timestamp]
    def getNoncompliantEvidenceCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "noncompliantEvidenceCount",
        noncompliantEvidenceCount
      )
    def getCompliantEvidenceCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "compliantEvidenceCount",
        compliantEvidenceCount
      )
    def getInconclusiveEvidenceCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "inconclusiveEvidenceCount",
        inconclusiveEvidenceCount
      )
    def getAssessmentControlsCountByNoncompliantEvidence
        : ZIO[Any, AwsError, NullableInteger] = AwsError.unwrapOptionField(
      "assessmentControlsCountByNoncompliantEvidence",
      assessmentControlsCountByNoncompliantEvidence
    )
    def getTotalAssessmentControlsCount: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField(
        "totalAssessmentControlsCount",
        totalAssessmentControlsCount
      )
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.InsightsByAssessment
  ) extends zio.aws.auditmanager.model.InsightsByAssessment.ReadOnly {
    override val noncompliantEvidenceCount: Option[NullableInteger] = scala
      .Option(impl.noncompliantEvidenceCount())
      .map(value => value: NullableInteger)
    override val compliantEvidenceCount: Option[NullableInteger] = scala
      .Option(impl.compliantEvidenceCount())
      .map(value => value: NullableInteger)
    override val inconclusiveEvidenceCount: Option[NullableInteger] = scala
      .Option(impl.inconclusiveEvidenceCount())
      .map(value => value: NullableInteger)
    override val assessmentControlsCountByNoncompliantEvidence
        : Option[NullableInteger] = scala
      .Option(impl.assessmentControlsCountByNoncompliantEvidence())
      .map(value => value: NullableInteger)
    override val totalAssessmentControlsCount: Option[NullableInteger] = scala
      .Option(impl.totalAssessmentControlsCount())
      .map(value => value: NullableInteger)
    override val lastUpdated: Option[Timestamp] = scala
      .Option(impl.lastUpdated())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.InsightsByAssessment
  ): zio.aws.auditmanager.model.InsightsByAssessment.ReadOnly = new Wrapper(
    impl
  )
}
