package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInsightsByAssessmentResponse(
    insights: Option[zio.aws.auditmanager.model.InsightsByAssessment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentResponse = {
    import GetInsightsByAssessmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentResponse
      .builder()
      .optionallyWith(insights.map(value => value.buildAwsValue()))(_.insights)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetInsightsByAssessmentResponse.ReadOnly =
    zio.aws.auditmanager.model.GetInsightsByAssessmentResponse
      .wrap(buildAwsValue())
}
object GetInsightsByAssessmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetInsightsByAssessmentResponse =
      zio.aws.auditmanager.model.GetInsightsByAssessmentResponse(
        insights.map(value => value.asEditable)
      )
    def insights
        : Option[zio.aws.auditmanager.model.InsightsByAssessment.ReadOnly]
    def getInsights: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.InsightsByAssessment.ReadOnly
    ] = AwsError.unwrapOptionField("insights", insights)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentResponse
  ) extends zio.aws.auditmanager.model.GetInsightsByAssessmentResponse.ReadOnly {
    override val insights
        : Option[zio.aws.auditmanager.model.InsightsByAssessment.ReadOnly] =
      scala
        .Option(impl.insights())
        .map(value =>
          zio.aws.auditmanager.model.InsightsByAssessment.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetInsightsByAssessmentResponse
  ): zio.aws.auditmanager.model.GetInsightsByAssessmentResponse.ReadOnly =
    new Wrapper(impl)
}
