package zio.aws.auditmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{MaxResults, Token, UUID}
import scala.jdk.CollectionConverters.*
final case class GetEvidenceFoldersByAssessmentRequest(
    assessmentId: UUID,
    nextToken: Option[Token] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest = {
    import GetEvidenceFoldersByAssessmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentRequest.ReadOnly =
    zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentRequest
      .wrap(buildAwsValue())
}
object GetEvidenceFoldersByAssessmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentRequest =
      zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentRequest(
        assessmentId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def assessmentId: UUID
    def nextToken: Option[Token]
    def maxResults: Option[MaxResults]
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest
  ) extends zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.auditmanager.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceFoldersByAssessmentRequest
  ): zio.aws.auditmanager.model.GetEvidenceFoldersByAssessmentRequest.ReadOnly =
    new Wrapper(impl)
}
